/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds.cache;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.EmailVerificationToken;
import com.stormpath.sdk.account.PasswordResetToken;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyList;
import com.stormpath.sdk.cache.Cache;
import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.impl.account.DefaultAccount;
import com.stormpath.sdk.impl.api.ApiKeyParameter;
import com.stormpath.sdk.impl.ds.CacheMapInitializer;
import com.stormpath.sdk.impl.ds.DefaultCacheMapInitializer;
import com.stormpath.sdk.impl.ds.DefaultResourceFactory;
import com.stormpath.sdk.impl.ds.FilterChain;
import com.stormpath.sdk.impl.ds.ResourceAction;
import com.stormpath.sdk.impl.ds.ResourceDataRequest;
import com.stormpath.sdk.impl.ds.ResourceDataResult;
import com.stormpath.sdk.impl.ds.cache.AbstractCacheFilter;
import com.stormpath.sdk.impl.ds.cache.CacheResolver;
import com.stormpath.sdk.impl.http.QueryString;
import com.stormpath.sdk.impl.resource.AbstractExtendableInstanceResource;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.impl.resource.ArrayProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ReferenceFactory;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.mail.ModeledEmailTemplate;
import com.stormpath.sdk.oauth.AccessToken;
import com.stormpath.sdk.oauth.RefreshToken;
import com.stormpath.sdk.provider.ProviderAccountResult;
import com.stormpath.sdk.resource.CollectionResource;
import com.stormpath.sdk.resource.Resource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class WriteCacheFilter
extends AbstractCacheFilter {
    private final ReferenceFactory referenceFactory;
    private final CacheMapInitializer cacheMapInitializer;

    public WriteCacheFilter(CacheResolver cacheResolver, boolean collectionCachingEnabled, ReferenceFactory referenceFactory) {
        super(cacheResolver, collectionCachingEnabled);
        Assert.notNull((Object)referenceFactory, (String)"referenceFactory cannot be null.");
        this.referenceFactory = referenceFactory;
        this.cacheMapInitializer = new DefaultCacheMapInitializer();
    }

    @Override
    public ResourceDataResult filter(ResourceDataRequest request, FilterChain chain) {
        ResourceDataResult result;
        if (request.getAction() == ResourceAction.DELETE) {
            String key = this.getCacheKey(request);
            this.uncache(key, request.getResourceClass());
        }
        if (this.isCacheable(request, result = chain.filter(request))) {
            this.cache(result.getResourceClass(), result.getData(), result.getUri().getQuery());
        }
        if (AbstractExtendableInstanceResource.isExtendableInstanceResource(result.getData())) {
            this.cacheNestedCustomData(request.getUri().getAbsolutePath(), request.getData());
        }
        return result;
    }

    private boolean isCacheable(ResourceDataRequest request, ResourceDataResult result) {
        String accountHref;
        boolean emailVerification;
        if (Collections.isEmpty(result.getData())) {
            return false;
        }
        Class<? extends Resource> clazz = result.getResourceClass();
        boolean bl = emailVerification = EmailVerificationToken.class.isAssignableFrom(request.getResourceClass()) && Account.class.isAssignableFrom(clazz);
        if (emailVerification && Strings.hasText((String)(accountHref = (String)result.getData().get("href")))) {
            Cache<String, Map<String, ?>> cache = this.getCache(Account.class);
            cache.remove((Object)accountHref);
        }
        return !PasswordResetToken.class.isAssignableFrom(clazz) && !ProviderAccountResult.class.isAssignableFrom(clazz) && AbstractResource.isMaterialized(result.getData()) && !AccessToken.class.isAssignableFrom(clazz);
    }

    private void cacheNestedCustomData(String directoryEntityHref, Map<String, Object> props) {
        Map customData = (Map)props.get(AbstractExtendableInstanceResource.CUSTOM_DATA.getName());
        if (customData != null) {
            customData.remove("href");
        }
        if (Collections.isEmpty((Map)customData)) {
            return;
        }
        LinkedHashMap<String, String> customDataToCache = new LinkedHashMap<String, String>();
        String customDataHref = directoryEntityHref + "/customData";
        customDataToCache.put("href", customDataHref);
        Map<String, ?> existingCustomData = this.getCachedValue(customDataHref, CustomData.class);
        if (!Collections.isEmpty(existingCustomData)) {
            existingCustomData.remove("href");
            customDataToCache.putAll(existingCustomData);
        }
        customDataToCache.putAll(customData);
        this.cache(CustomData.class, customDataToCache, null);
    }

    private void cache(Class<? extends Resource> clazz, Map<String, ?> data, QueryString queryString) {
        Assert.notEmpty(data, (String)"Resource data cannot be null or empty.");
        String href = (String)data.get("href");
        if (this.isDirectlyCacheable(clazz, data)) {
            Assert.notNull((Object)href, (String)"Resource data must contain an 'href' attribute.");
            Assert.isTrue((data.size() > 1 ? 1 : 0) != 0, (String)"Resource data must be materialized to be cached (need more than just an 'href' attribute).");
        }
        Map<String, Object> cacheValue = this.cacheMapInitializer.initialize(clazz, data, queryString);
        if (CustomData.class.isAssignableFrom(clazz)) {
            Cache<String, Map<String, ?>> cache = this.getCache(clazz);
            cache.put((Object)href, cacheValue);
            return;
        }
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            boolean isApiEncryptionMetadata;
            String name = entry.getKey();
            Object value = entry.getValue();
            boolean isDefaultModelMap = ModeledEmailTemplate.class.isAssignableFrom(clazz) && name.equals("defaultModel");
            boolean isTokenDataMap = (AccessToken.class.isAssignableFrom(clazz) || RefreshToken.class.isAssignableFrom(clazz)) && name.equals("expandedJwt");
            boolean bl = isApiEncryptionMetadata = ApiKey.class.isAssignableFrom(clazz) && name.equals(ApiKeyParameter.ENCRYPTION_METADATA.getName());
            if (isDefaultModelMap || isTokenDataMap) {
                value = new LinkedHashMap((Map)value);
            }
            if (value instanceof Map && !isDefaultModelMap && !isTokenDataMap && !isApiEncryptionMetadata) {
                Map nested = (Map)value;
                Assert.notEmpty((Map)nested, (String)"Resource references are expected to be complex objects with at least an 'href' property.");
                Assert.notNull(nested.get("href"), (String)"Resource references must have an 'href' attribute.");
                if (AbstractResource.isMaterialized(nested)) {
                    Property property = this.getPropertyDescriptor(clazz, name);
                    Assert.isTrue((boolean)(property instanceof ResourceReference), (String)"It is expected that only ResourceReference properties are complex objects.");
                    this.cache(property.getType(), nested, null);
                    value = this.toCanonicalReference(name, nested);
                }
            } else if (value instanceof Collection && name.equals("items") && data.get("href") != null) {
                Collection c = (Collection)value;
                ArrayList list = new ArrayList(c.size());
                Property property = this.getPropertyDescriptor(clazz, name);
                Assert.isTrue((boolean)(property instanceof ArrayProperty), (String)"It is expected that only ArrayProperty properties represent collection items.");
                ArrayProperty itemsProperty = (ArrayProperty)ArrayProperty.class.cast(property);
                Class itemType = itemsProperty.getType();
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    Map referenceData;
                    Object o;
                    Object element = o = iterator.next();
                    if (o instanceof Map && AbstractResource.isMaterialized(referenceData = (Map)o)) {
                        this.cache(itemType, referenceData, null);
                        element = this.toCanonicalReference(null, referenceData);
                    }
                    list.add(element);
                }
                value = list;
            }
            if (DefaultAccount.PASSWORD.getName().equals(name)) continue;
            cacheValue.put(name, value);
        }
        if (this.isDirectlyCacheable(clazz, cacheValue)) {
            Iterator<Map.Entry<String, ?>> cache = this.getCache(clazz);
            String cacheKey = this.getCacheKey(href, queryString, clazz);
            cache.put(cacheKey, cacheValue);
        }
    }

    private Map<String, ?> toCanonicalReference(String name, Map<String, ?> resourceData) {
        if (AbstractInstanceResource.isInstanceResource(resourceData)) {
            return this.referenceFactory.createReference(name, resourceData);
        }
        return resourceData;
    }

    private <T extends Resource> Property getPropertyDescriptor(Class<T> clazz, String propertyName) {
        Map<String, Property> descriptors = this.getPropertyDescriptors(clazz);
        return descriptors.get(propertyName);
    }

    private <T extends Resource> Map<String, Property> getPropertyDescriptors(Class<T> clazz) {
        Class<T> implClass = DefaultResourceFactory.getImplementationClass(clazz);
        try {
            Field field = implClass.getDeclaredField("PROPERTY_DESCRIPTORS");
            field.setAccessible(true);
            return (Map)field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to access PROPERTY_DESCRIPTORS static field on implementation class " + clazz.getName(), e);
        }
    }

    private boolean isDirectlyCacheable(Class<? extends Resource> clazz, Map<String, ?> data) {
        return AbstractResource.isMaterialized(data) && (!CollectionResource.class.isAssignableFrom(clazz) || CollectionResource.class.isAssignableFrom(clazz) && this.isCollectionCachingEnabled());
    }

    private void uncache(String cacheKey, Class<? extends Resource> resourceType) {
        Assert.hasText((String)cacheKey, (String)"cacheKey cannot be null or empty.");
        Assert.notNull(resourceType, (String)"resourceType cannot be null.");
        Cache<String, Map<String, ?>> cache = this.getCache(resourceType);
        cache.remove((Object)cacheKey);
    }

    private boolean isApiKeyCollectionQuery(ResourceDataRequest request) {
        return ApiKeyList.class.isAssignableFrom(request.getResourceClass()) && request.getUri().hasQuery() && request.getUri().getQuery().containsKey(ApiKeyParameter.ID.getName());
    }
}

