/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.stormpath.sdk.impl.ds.MapMarshaller;
import com.stormpath.sdk.impl.ds.MarshalingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class JacksonMapMarshaller
implements MapMarshaller {
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean prettyPrint = false;

    public JacksonMapMarshaller() {
        this.objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isPrettyPrint() {
        return this.objectMapper.getSerializationConfig().isEnabled(SerializationFeature.INDENT_OUTPUT);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
    }

    @Override
    public String marshal(Map map) {
        try {
            return this.objectMapper.writeValueAsString((Object)map);
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert Map to JSON String.", e);
        }
    }

    @Override
    public Map unmarshal(String marshalled) {
        try {
            TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
            return (Map)this.objectMapper.readValue(marshalled, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert JSON String to Map.", e);
        }
    }

    @Override
    public Map<String, Object> unmarshall(InputStream marshalled) {
        try {
            TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
            return (Map)this.objectMapper.readValue(marshalled, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert InputStream String to Map.", e);
        }
    }
}

