/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.directory;

import com.stormpath.sdk.directory.PasswordStrength;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.IntegerProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.lang.Assert;
import java.util.Map;

public class DefaultPasswordStrength
extends AbstractInstanceResource
implements PasswordStrength {
    static final IntegerProperty MIN_SYMBOL = new IntegerProperty("minSymbol");
    static final IntegerProperty MIN_DIACRITIC = new IntegerProperty("minDiacritic");
    static final IntegerProperty MIN_UPPERCASE = new IntegerProperty("minUpperCase");
    static final IntegerProperty MIN_LENGTH = new IntegerProperty("minLength");
    static final IntegerProperty MIN_LOWERCASE = new IntegerProperty("minLowerCase");
    static final IntegerProperty MAX_LENGTH = new IntegerProperty("maxLength");
    static final IntegerProperty MIN_NUMERIC = new IntegerProperty("minNumeric");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultPasswordStrength.createPropertyDescriptorMap(MIN_SYMBOL, MIN_DIACRITIC, MIN_UPPERCASE, MIN_LENGTH, MIN_LOWERCASE, MAX_LENGTH, MIN_NUMERIC);

    public DefaultPasswordStrength(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultPasswordStrength(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public int getMinSymbol() {
        return this.getInt(MIN_SYMBOL);
    }

    public PasswordStrength setMinSymbol(int minSymbol) {
        Assert.isTrue((minSymbol >= 0 ? 1 : 0) != 0, (String)"minSymbol cannot be a negative number.");
        this.setProperty(MIN_SYMBOL, (Object)minSymbol);
        return this;
    }

    public int getMinDiacritic() {
        return this.getInt(MIN_DIACRITIC);
    }

    public PasswordStrength setMinDiacritic(int minDiacritic) {
        Assert.isTrue((minDiacritic >= 0 ? 1 : 0) != 0, (String)"minDiacritic cannot be a negative number.");
        this.setProperty(MIN_DIACRITIC, (Object)minDiacritic);
        return this;
    }

    public int getMinUpperCase() {
        return this.getInt(MIN_UPPERCASE);
    }

    public PasswordStrength setMinUpperCase(int minUpperCase) {
        Assert.isTrue((minUpperCase >= 0 ? 1 : 0) != 0, (String)"minUpperCase cannot be a negative number.");
        this.setProperty(MIN_UPPERCASE, (Object)minUpperCase);
        return this;
    }

    public int getMinLength() {
        return this.getInt(MIN_LENGTH);
    }

    public PasswordStrength setMinLength(int minLength) {
        Assert.isTrue((minLength > 0 && minLength <= 1024 ? 1 : 0) != 0, (String)"minLength cannot be less than 1 or larger than 1024.");
        this.setProperty(MIN_LENGTH, (Object)minLength);
        return this;
    }

    public int getMinLowerCase() {
        return this.getInt(MIN_LOWERCASE);
    }

    public PasswordStrength setMinLowerCase(int minLowerCase) {
        Assert.isTrue((minLowerCase >= 0 ? 1 : 0) != 0, (String)"minLowerCase cannot be a negative number.");
        this.setProperty(MIN_LOWERCASE, (Object)minLowerCase);
        return this;
    }

    public int getMaxLength() {
        return this.getInt(MAX_LENGTH);
    }

    public PasswordStrength setMaxLength(int maxLength) {
        Assert.isTrue((maxLength > 0 && maxLength <= 1024 ? 1 : 0) != 0, (String)"maxLength cannot be less than 1 or larger than 1024.");
        this.setProperty(MAX_LENGTH, (Object)maxLength);
        return this;
    }

    public int getMinNumeric() {
        return this.getInt(MIN_NUMERIC);
    }

    public PasswordStrength setMinNumeric(int minNumeric) {
        Assert.isTrue((minNumeric >= 0 ? 1 : 0) != 0, (String)"minNumeric cannot be a negative number.");
        this.setProperty(MIN_NUMERIC, (Object)minNumeric);
        return this;
    }

    @Override
    public void save() {
        Assert.isTrue((this.getMaxLength() >= this.getMinLength() ? 1 : 0) != 0, (String)"minLength cannot be greater than maxLength.");
        Assert.isTrue((this.getMinSymbol() + this.getMinDiacritic() + this.getMinUpperCase() + this.getMinLowerCase() + this.getMinNumeric() <= this.getMaxLength() ? 1 : 0) != 0, (String)"maxLength is not large enough to hold all the minimum conditions specified.");
        super.save();
    }
}

