/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.stormpath.sdk.impl.config.PropertiesSource;
import com.stormpath.sdk.impl.io.Resource;
import com.stormpath.sdk.lang.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JSONPropertiesSource
implements PropertiesSource {
    private final Resource resource;

    public JSONPropertiesSource(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource argument cannot be null.");
        this.resource = resource;
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        try (InputStream in = this.resource.getInputStream();){
            if (in != null) {
                this.getFlattenedMap("", new ObjectMapper().readTree(this.resource.getInputStream()), map);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read resource [" + this.resource + "]: " + e.getMessage(), e);
        }
        return map;
    }

    private void getFlattenedMap(String currentPath, JsonNode jsonNode, Map<String, String> map) {
        if (jsonNode.isObject()) {
            String pathPrefix;
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Iterator iter = objectNode.fields();
            String string = pathPrefix = currentPath.isEmpty() ? "" : currentPath + ".";
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.getFlattenedMap(pathPrefix + (String)entry.getKey(), (JsonNode)entry.getValue(), map);
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                this.getFlattenedMap(currentPath + "[" + i + "]", arrayNode.get(i), map);
            }
        } else if (jsonNode.isValueNode()) {
            ValueNode valueNode = (ValueNode)jsonNode;
            map.put(currentPath, valueNode.asText());
        }
    }
}

