/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc.credentials;

import com.stormpath.sdk.impl.authc.credentials.AbstractApiKeyCredentialsProvider;
import com.stormpath.sdk.lang.Strings;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyFileCredentialsProvider
extends AbstractApiKeyCredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyFileCredentialsProvider.class);
    private static final String ERROR_MSG = "Unable to find or load default api key properties file [{}]. This can be safely ignored as this is a fallback location - other more specific locations will be checked.";
    private final String apiKeyPropertiesFileLocation;

    public ApiKeyFileCredentialsProvider() {
        this(DEFAULT_API_KEY_PROPERTIES_FILE_LOCATION);
    }

    public ApiKeyFileCredentialsProvider(String apiKeyPropertiesFileLocation) {
        this.apiKeyPropertiesFileLocation = apiKeyPropertiesFileLocation;
    }

    @Override
    protected Properties loadProperties() {
        Properties props = new Properties();
        if (Strings.hasText((String)this.apiKeyPropertiesFileLocation)) {
            try {
                Reader reader = this.createFileReader(this.apiKeyPropertiesFileLocation);
                props = ApiKeyFileCredentialsProvider.toProperties(reader);
            }
            catch (IOException ignored) {
                log.debug(ERROR_MSG, (Object)this.apiKeyPropertiesFileLocation, (Object)ignored);
            }
        }
        return props;
    }
}

