/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc;

import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.BasicAuthenticationOptions;
import com.stormpath.sdk.authc.UsernamePasswordRequestBuilder;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.impl.authc.DefaultUsernamePasswordRequest;
import com.stormpath.sdk.lang.Assert;

public class DefaultUsernamePasswordRequestBuilder
implements UsernamePasswordRequestBuilder {
    private String usernameOrEmail;
    private char[] password;
    private String host;
    private AccountStore accountStore;
    private BasicAuthenticationOptions options;

    public UsernamePasswordRequestBuilder setUsernameOrEmail(String usernameOrEmail) {
        Assert.hasText((String)usernameOrEmail, (String)"usernameOrEmail cannot be null or empty.");
        this.usernameOrEmail = usernameOrEmail;
        return this;
    }

    public UsernamePasswordRequestBuilder setPassword(String password) {
        this.password = password != null ? password.toCharArray() : "".toCharArray();
        return this;
    }

    public UsernamePasswordRequestBuilder setPassword(char[] password) {
        this.password = password;
        return this;
    }

    public UsernamePasswordRequestBuilder setHost(String host) {
        Assert.notNull((Object)host, (String)"host cannot be null.");
        this.host = host;
        return this;
    }

    public UsernamePasswordRequestBuilder inAccountStore(AccountStore accountStore) {
        Assert.notNull((Object)accountStore, (String)"accountStore cannot be null.");
        this.accountStore = accountStore;
        return this;
    }

    public UsernamePasswordRequestBuilder withResponseOptions(BasicAuthenticationOptions options) {
        Assert.notNull((Object)options, (String)"options cannot be null.");
        this.options = options;
        return this;
    }

    public AuthenticationRequest build() {
        Assert.state((this.usernameOrEmail != null ? 1 : 0) != 0, (String)"usernameOrEmail has not been set. It is a required attribute.");
        DefaultUsernamePasswordRequest request = new DefaultUsernamePasswordRequest(this.usernameOrEmail, this.password);
        if (this.host != null) {
            request.setHost(this.host);
        }
        if (this.accountStore != null) {
            request.setAccountStore(this.accountStore);
        }
        if (this.options != null) {
            request.setResponseOptions(this.options);
        }
        return request;
    }
}

