/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.api.ApiAuthenticationResult;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.authc.AuthenticationResultVisitor;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import java.util.HashMap;
import java.util.Map;

public class DefaultApiAuthenticationResult
extends AbstractResource
implements ApiAuthenticationResult {
    public static final ResourceReference<ApiKey> API_KEY = new ResourceReference<ApiKey>("apiKey", ApiKey.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultApiAuthenticationResult.createPropertyDescriptorMap(API_KEY);

    protected static Map<String, Object> buildPropertiesWithApiKeyApiKey(ApiKey apiKey) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(API_KEY.getName(), apiKey);
        return properties;
    }

    public DefaultApiAuthenticationResult(InternalDataStore dataStore, ApiKey apiKey) {
        super(dataStore, DefaultApiAuthenticationResult.buildPropertiesWithApiKeyApiKey(apiKey));
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public ApiKey getApiKey() {
        return this.getResourceProperty(API_KEY);
    }

    public Account getAccount() {
        return this.getApiKey().getAccount();
    }

    public void accept(AuthenticationResultVisitor visitor) {
        visitor.visit((ApiAuthenticationResult)this);
    }
}

