/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.PasswordResetToken;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.resource.Resource;
import java.util.Map;

public class DefaultPasswordResetToken
extends AbstractResource
implements PasswordResetToken {
    private static final String TOKEN_DELIMITER = "/passwordResetTokens/";
    static final StringProperty EMAIL = new StringProperty("email");
    static final StringProperty PASSWORD = new StringProperty("password");
    static final ResourceReference<Account> ACCOUNT = new ResourceReference<Account>("account", Account.class);
    static final ResourceReference<AccountStore> ACCOUNT_STORE = new ResourceReference<AccountStore>("accountStore", AccountStore.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultPasswordResetToken.createPropertyDescriptorMap(EMAIL, ACCOUNT_STORE, PASSWORD, ACCOUNT);

    public DefaultPasswordResetToken(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultPasswordResetToken(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getEmail() {
        return this.getString(EMAIL);
    }

    public PasswordResetToken setEmail(String email) {
        this.setProperty(EMAIL, (Object)email);
        return this;
    }

    public Account getAccount() {
        return this.getResourceProperty(ACCOUNT);
    }

    public PasswordResetToken setAccountStore(AccountStore accountStore) {
        this.setResourceProperty(ACCOUNT_STORE, (Resource)accountStore);
        return this;
    }

    public AccountStore getAccountStore() {
        return this.getResourceProperty(ACCOUNT_STORE);
    }

    public PasswordResetToken setPassword(String password) {
        this.setProperty(PASSWORD, (Object)password);
        return this;
    }

    public String getValue() {
        String href = this.getHref();
        if (href != null) {
            String token = href.substring(href.indexOf(TOKEN_DELIMITER) + TOKEN_DELIMITER.length());
            return token;
        }
        return null;
    }
}

