/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.connection;

import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.metrics.SignalFxMetricsException;
import com.signalfx.metrics.connection.DataPointReceiver;
import com.signalfx.metrics.connection.DataPointReceiverFactory;
import com.signalfx.metrics.connection.HttpDataPointProtobufReceiverConnection;
import com.signalfx.metrics.connection.HttpDataPointProtobufReceiverConnectionV2;
import com.signalfx.shaded.apache.http.config.RegistryBuilder;
import com.signalfx.shaded.apache.http.conn.HttpClientConnectionManager;
import com.signalfx.shaded.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.signalfx.shaded.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.signalfx.shaded.apache.http.conn.ssl.SSLContexts;
import com.signalfx.shaded.apache.http.impl.conn.BasicHttpClientConnectionManager;

public class HttpDataPointProtobufReceiverFactory
implements DataPointReceiverFactory {
    public static final int DEFAULT_TIMEOUT_MS = 2000;
    public static final int DEFAULT_VERSION = 2;
    private final SignalFxReceiverEndpoint endpoint;
    private HttpClientConnectionManager httpClientConnectionManager;
    private int timeoutMs = 2000;
    private int version = 2;

    public HttpDataPointProtobufReceiverFactory(SignalFxReceiverEndpoint endpoint) {
        this.endpoint = endpoint;
        this.httpClientConnectionManager = new BasicHttpClientConnectionManager(RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER))).build());
    }

    public HttpDataPointProtobufReceiverFactory setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public HttpDataPointProtobufReceiverFactory setVersion(int version) {
        this.version = version;
        return this;
    }

    public void setHttpClientConnectionManager(HttpClientConnectionManager httpClientConnectionManager) {
        this.httpClientConnectionManager = httpClientConnectionManager;
    }

    @Override
    public DataPointReceiver createDataPointReceiver() throws SignalFxMetricsException {
        if (this.version == 1) {
            return new HttpDataPointProtobufReceiverConnection(this.endpoint, this.timeoutMs, this.httpClientConnectionManager);
        }
        return new HttpDataPointProtobufReceiverConnectionV2(this.endpoint, this.timeoutMs, this.httpClientConnectionManager);
    }
}

