/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.model.FetchRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.storage.model.FileListing;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.util.ArrayList;
import java.util.Iterator;

public final class BucketManager {
    private final Auth auth;
    private final Configuration configuration;
    private final Client client;

    public BucketManager(Auth auth, Configuration cfg) {
        this.auth = auth;
        this.configuration = cfg.clone();
        this.client = new Client(this.configuration);
    }

    public static String encodedEntry(String bucket, String key) {
        String encodedEntry = key != null ? UrlSafeBase64.encodeToString(bucket + ":" + key) : UrlSafeBase64.encodeToString(bucket);
        return encodedEntry;
    }

    public static String encodedEntry(String bucket) {
        return BucketManager.encodedEntry(bucket, null);
    }

    public String[] buckets() throws QiniuException {
        String url = String.format("%s/buckets", this.configuration.rsHost());
        Response r = this.get(url);
        return r.jsonToObject(String[].class);
    }

    public FileListIterator createFileListIterator(String bucket, String prefix) {
        return new FileListIterator(bucket, prefix, 1000, null);
    }

    public FileListIterator createFileListIterator(String bucket, String prefix, int limit, String delimiter) {
        return new FileListIterator(bucket, prefix, limit, delimiter);
    }

    public FileListing listFiles(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        StringMap map = new StringMap().put("bucket", bucket).putNotEmpty("marker", marker).putNotEmpty("prefix", prefix).putNotEmpty("delimiter", delimiter).putWhen("limit", limit, limit > 0);
        String url = String.format("%s/list?%s", this.configuration.rsfHost(this.auth.accessKey, bucket), map.formString());
        Response r = this.get(url);
        return r.jsonToObject(FileListing.class);
    }

    public FileInfo stat(String bucket, String fileKey) throws QiniuException {
        Response r = this.rsGet(bucket, String.format("/stat/%s", BucketManager.encodedEntry(bucket, fileKey)));
        return r.jsonToObject(FileInfo.class);
    }

    public Response delete(String bucket, String key) throws QiniuException {
        return this.rsPost(bucket, String.format("/delete/%s", BucketManager.encodedEntry(bucket, key)), null);
    }

    public Response changeMime(String bucket, String key, String mime) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String encodedMime = UrlSafeBase64.encodeToString(mime);
        String path = String.format("/chgm/%s/mime/%s", resource, encodedMime);
        return this.rsPost(bucket, path, null);
    }

    public Response rename(String bucket, String oldFileKey, String newFileKey, boolean force) throws QiniuException {
        return this.move(bucket, oldFileKey, bucket, newFileKey, force);
    }

    public Response rename(String bucket, String oldFileKey, String newFileKey) throws QiniuException {
        return this.move(bucket, oldFileKey, bucket, newFileKey);
    }

    public Response copy(String fromBucket, String fromFileKey, String toBucket, String toFileKey, boolean force) throws QiniuException {
        String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
        String to = BucketManager.encodedEntry(toBucket, toFileKey);
        String path = String.format("/copy/%s/%s/force/%s", from, to, force);
        return this.rsPost(fromBucket, path, null);
    }

    public void copy(String fromBucket, String fromFileKey, String toBucket, String toFileKey) throws QiniuException {
        this.copy(fromBucket, fromFileKey, toBucket, toFileKey, false);
    }

    public Response move(String fromBucket, String fromFileKey, String toBucket, String toFileKey, boolean force) throws QiniuException {
        String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
        String to = BucketManager.encodedEntry(toBucket, toFileKey);
        String path = String.format("/move/%s/%s/force/%s", from, to, force);
        return this.rsPost(fromBucket, path, null);
    }

    public Response move(String fromBucket, String fromFileKey, String toBucket, String toFileKey) throws QiniuException {
        return this.move(fromBucket, fromFileKey, toBucket, toFileKey, false);
    }

    public FetchRet fetch(String url, String bucket) throws QiniuException {
        return this.fetch(url, bucket, null);
    }

    public FetchRet fetch(String url, String bucket, String key) throws QiniuException {
        String resource = UrlSafeBase64.encodeToString(url);
        String to = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/fetch/%s/to/%s", resource, to);
        Response r = this.ioPost(bucket, path);
        return r.jsonToObject(FetchRet.class);
    }

    public void prefetch(String bucket, String key) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/prefetch/%s", resource);
        this.ioPost(bucket, path);
    }

    public Response setImage(String bucket, String srcSiteUrl) throws QiniuException {
        return this.setImage(bucket, srcSiteUrl, null);
    }

    public Response setImage(String bucket, String srcSiteUrl, String host) throws QiniuException {
        String encodedSiteUrl = UrlSafeBase64.encodeToString(srcSiteUrl);
        String encodedHost = null;
        if (host != null && host.length() > 0) {
            encodedHost = UrlSafeBase64.encodeToString(host);
        }
        String path = String.format("/image/%s/from/%s", bucket, encodedSiteUrl);
        if (encodedHost != null) {
            path = path + String.format("/host/%s", encodedHost);
        }
        return this.pubPost(path);
    }

    public Response unsetImage(String bucket) throws QiniuException {
        String path = String.format("/unimage/%s", bucket);
        return this.pubPost(path);
    }

    public Response deleteAfterDays(String bucket, String key, int days) throws QiniuException {
        return this.rsPost(bucket, String.format("/deleteAfterDays/%s/%d", BucketManager.encodedEntry(bucket, key), days), null);
    }

    private Response rsPost(String bucket, String path, byte[] body) throws QiniuException {
        this.check(bucket);
        String url = this.configuration.rsHost(this.auth.accessKey, bucket) + path;
        return this.post(url, body);
    }

    private Response rsGet(String bucket, String path) throws QiniuException {
        this.check(bucket);
        String url = this.configuration.rsHost(this.auth.accessKey, bucket) + path;
        return this.get(url);
    }

    private Response ioPost(String bucket, String path) throws QiniuException {
        this.check(bucket);
        String url = this.configuration.ioHost(this.auth.accessKey, bucket) + path;
        return this.post(url, null);
    }

    private Response pubPost(String path) throws QiniuException {
        String url = "http://pu.qbox.me:10200" + path;
        return this.post(url, null);
    }

    private Response get(String url) throws QiniuException {
        StringMap headers = this.auth.authorization(url);
        return this.client.get(url, headers);
    }

    private Response post(String url, byte[] body) throws QiniuException {
        StringMap headers = this.auth.authorization(url, body, "application/x-www-form-urlencoded");
        return this.client.post(url, body, headers, "application/x-www-form-urlencoded");
    }

    private void check(String bucket) throws QiniuException {
        if (StringUtils.isNullOrEmpty(bucket)) {
            throw new QiniuException(Response.createError(null, null, 0.0, "\u672a\u6307\u5b9a\u64cd\u4f5c\u7684\u7a7a\u95f4\u6216\u64cd\u4f5c\u4f53\u4e3a\u7a7a"));
        }
    }

    public Response batch(BatchOperations operations) throws QiniuException {
        return this.rsPost(operations.execBucket(), "/batch", operations.toBody());
    }

    public class FileListIterator
    implements Iterator<FileInfo[]> {
        private String marker = null;
        private String bucket;
        private String delimiter;
        private int limit;
        private String prefix;
        private QiniuException exception = null;

        public FileListIterator(String bucket, String prefix, int limit, String delimiter) {
            if (limit <= 0) {
                throw new IllegalArgumentException("limit must greater than 0");
            }
            if (limit > 1000) {
                throw new IllegalArgumentException("limit must not greater than 1000");
            }
            this.bucket = bucket;
            this.prefix = prefix;
            this.limit = limit;
            this.delimiter = delimiter;
        }

        public QiniuException error() {
            return this.exception;
        }

        @Override
        public boolean hasNext() {
            return this.exception == null && !"".equals(this.marker);
        }

        @Override
        public FileInfo[] next() {
            try {
                FileListing f = BucketManager.this.listFiles(this.bucket, this.prefix, this.marker, this.limit, this.delimiter);
                this.marker = f.marker == null ? "" : f.marker;
                return f.items;
            }
            catch (QiniuException e) {
                this.exception = e;
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class BatchOperations {
        private ArrayList<String> ops = new ArrayList();
        private String execBucket = null;

        public BatchOperations addChgmOp(String bucket, String key, String newMimeType) {
            String resource = BucketManager.encodedEntry(bucket, key);
            String encodedMime = UrlSafeBase64.encodeToString(newMimeType);
            this.ops.add(String.format("/chgm/%s/mime/%s", resource, encodedMime));
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addCopyOp(String fromBucket, String fromFileKey, String toBucket, String toFileKey) {
            String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
            String to = BucketManager.encodedEntry(toBucket, toFileKey);
            this.ops.add(String.format("copy/%s/%s", from, to));
            this.setExecBucket(fromBucket);
            return this;
        }

        public BatchOperations addRenameOp(String fromBucket, String fromFileKey, String toFileKey) {
            return this.addMoveOp(fromBucket, fromFileKey, fromBucket, toFileKey);
        }

        public BatchOperations addMoveOp(String fromBucket, String fromKey, String toBucket, String toKey) {
            String from = BucketManager.encodedEntry(fromBucket, fromKey);
            String to = BucketManager.encodedEntry(toBucket, toKey);
            this.ops.add(String.format("move/%s/%s", from, to));
            this.setExecBucket(fromBucket);
            return this;
        }

        public BatchOperations addDeleteOp(String bucket, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("delete/%s", BucketManager.encodedEntry(bucket, key)));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addStatOps(String bucket, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("stat/%s", BucketManager.encodedEntry(bucket, key)));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public byte[] toBody() {
            String body = StringUtils.join(this.ops, "&op=", "op=");
            return StringUtils.utf8Bytes(body);
        }

        public BatchOperations merge(BatchOperations batch) {
            this.ops.addAll(batch.ops);
            this.setExecBucket(batch.execBucket());
            return this;
        }

        public BatchOperations clearOps() {
            this.ops.clear();
            return this;
        }

        private void setExecBucket(String bucket) {
            if (this.execBucket == null) {
                this.execBucket = bucket;
            }
        }

        public String execBucket() {
            return this.execBucket;
        }
    }
}

