/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.driver.APIOptionCollector;
import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.hosted.option.HostedOptionParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.nativeimage.ImageSingletons;

class APIOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    private final SortedMap<String, OptionInfo> apiOptions;

    APIOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
        if (NativeImage.IS_AOT) {
            this.apiOptions = ((APIOptionCollector)ImageSingletons.lookup(APIOptionCollector.class)).options;
        } else {
            ArrayList<Class<? extends OptionDescriptors>> optionDescriptorsList = new ArrayList<Class<? extends OptionDescriptors>>();
            ServiceLoader<OptionDescriptors> serviceLoader = ServiceLoader.load(OptionDescriptors.class, nativeImage.getClass().getClassLoader());
            for (OptionDescriptors optionDescriptors : serviceLoader) {
                optionDescriptorsList.add(optionDescriptors.getClass());
            }
            this.apiOptions = APIOptionHandler.extractOptions(optionDescriptorsList);
        }
    }

    static SortedMap<String, OptionInfo> extractOptions(List<Class<? extends OptionDescriptors>> optionsClasses) {
        TreeMap hostedOptions = new TreeMap();
        TreeMap runtimeOptions = new TreeMap();
        HostedOptionParser.collectOptions(optionsClasses, hostedOptions, runtimeOptions);
        TreeMap<String, OptionInfo> apiOptions = new TreeMap<String, OptionInfo>();
        hostedOptions.values().forEach(o -> APIOptionHandler.extractOption("-H:", o, apiOptions));
        runtimeOptions.values().forEach(o -> APIOptionHandler.extractOption("-R:", o, apiOptions));
        return apiOptions;
    }

    private static void extractOption(String optionPrefix, OptionDescriptor optionDescriptor, SortedMap<String, OptionInfo> apiOptions) {
        try {
            APIOption[] apiAnnotations;
            Field optionField = optionDescriptor.getDeclaringClass().getDeclaredField(optionDescriptor.getFieldName());
            for (APIOption apiAnnotation : apiAnnotations = (APIOption[])optionField.getAnnotationsByType(APIOption.class)) {
                String builderOption = optionPrefix;
                String apiOptionName = APIOption.Utils.name((APIOption)apiAnnotation);
                String rawOptionName = optionDescriptor.getName();
                boolean booleanOption = false;
                if (optionDescriptor.getOptionValueType().equals(Boolean.class)) {
                    VMError.guarantee((!apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Paths) ? 1 : 0) != 0, (String)String.format("Boolean APIOption %s(%s) cannot use APIOptionKind.Paths", apiOptionName, rawOptionName));
                    VMError.guarantee((apiAnnotation.defaultValue().length == 0 ? 1 : 0) != 0, (String)String.format("Boolean APIOption %s(%s) cannot use APIOption.defaultValue", apiOptionName, rawOptionName));
                    VMError.guarantee((apiAnnotation.fixedValue().length == 0 ? 1 : 0) != 0, (String)String.format("Boolean APIOption %s(%s) cannot use APIOption.fixedValue", apiOptionName, rawOptionName));
                    builderOption = builderOption + (apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Negated) ? "-" : "+");
                    builderOption = builderOption + rawOptionName;
                    booleanOption = true;
                } else {
                    VMError.guarantee((!apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Negated) ? 1 : 0) != 0, (String)String.format("Non-boolean APIOption %s(%s) cannot use APIOptionKind.Negated", apiOptionName, rawOptionName));
                    VMError.guarantee((apiAnnotation.defaultValue().length <= 1 ? 1 : 0) != 0, (String)String.format("APIOption %s(%s) cannot have more than one APIOption.defaultValue", apiOptionName, rawOptionName));
                    VMError.guarantee((apiAnnotation.fixedValue().length <= 1 ? 1 : 0) != 0, (String)String.format("APIOption %s(%s) cannot have more than one APIOption.fixedValue", apiOptionName, rawOptionName));
                    VMError.guarantee((apiAnnotation.fixedValue().length == 0 && apiAnnotation.defaultValue().length == 0 || apiAnnotation.fixedValue().length > 0 ^ apiAnnotation.defaultValue().length > 0 ? 1 : 0) != 0, (String)String.format("APIOption %s(%s) APIOption.defaultValue and APIOption.fixedValue cannot be combined", apiOptionName, rawOptionName));
                    builderOption = builderOption + rawOptionName;
                    builderOption = builderOption + "=";
                }
                String helpText = optionDescriptor.getHelp();
                if (!apiAnnotation.customHelp().isEmpty()) {
                    helpText = apiAnnotation.customHelp();
                }
                VMError.guarantee((helpText != null && !helpText.isEmpty() ? 1 : 0) != 0, (String)String.format("APIOption %s(%s) needs to provide help text", apiOptionName, rawOptionName));
                helpText = helpText.substring(0, 1).toLowerCase() + helpText.substring(1);
                String defaultValue = null;
                if (apiAnnotation.defaultValue().length > 0) {
                    defaultValue = apiAnnotation.defaultValue()[0];
                }
                if (apiAnnotation.fixedValue().length > 0) {
                    defaultValue = apiAnnotation.fixedValue()[0];
                }
                ArrayList<Function<Object, Object>> valueTransformers = new ArrayList<Function<Object, Object>>(apiAnnotation.valueTransformer().length);
                for (Class transformerClass : apiAnnotation.valueTransformer()) {
                    try {
                        Constructor constructor = transformerClass.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        valueTransformers.add((Function<Object, Object>)constructor.newInstance(new Object[0]));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        throw VMError.shouldNotReachHere((String)("Class specified as valueTransformer for @APIOption " + apiOptionName + " cannot be loaded or instantiated: " + transformerClass.getTypeName()), (Throwable)ex);
                    }
                }
                apiOptions.put(apiOptionName, new OptionInfo(builderOption, defaultValue, helpText, apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Paths), booleanOption || apiAnnotation.fixedValue().length > 0, apiAnnotation.deprecated(), valueTransformers));
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    @Override
    boolean consume(Queue<String> args) {
        String headArg = args.peek();
        String translatedOption = this.translateOption(headArg);
        if (translatedOption != null) {
            args.poll();
            this.nativeImage.addPlainImageBuilderArg(translatedOption);
            return true;
        }
        return false;
    }

    String translateOption(String arg) {
        String[] optionParts = arg.split("=", 2);
        OptionInfo option = (OptionInfo)this.apiOptions.get(optionParts[0]);
        if (option != null) {
            if (!option.deprecationWarning.isEmpty()) {
                NativeImage.showWarning("Using a deprecated option " + optionParts[0] + ". " + option.deprecationWarning);
            }
            String builderOption = option.builderOption;
            String optionValue = option.defaultValue;
            if (optionParts.length == 2) {
                if (option.defaultFinal) {
                    NativeImage.showError("Passing values to option " + optionParts[0] + " is not supported.");
                }
                optionValue = optionParts[1];
            }
            if (optionValue != null) {
                if (option.hasPathArguments) {
                    optionValue = Arrays.stream(optionValue.split(",")).filter(s -> !s.isEmpty()).map(this::tryCanonicalize).collect(Collectors.joining(","));
                }
                Object transformed = optionValue;
                for (Function<Object, Object> transformer : option.valueTransformers) {
                    transformed = transformer.apply(transformed);
                }
                builderOption = builderOption + transformed.toString();
            }
            return builderOption;
        }
        return null;
    }

    private String tryCanonicalize(String path) {
        try {
            return this.nativeImage.canonicalize(Paths.get(path, new String[0])).toString();
        }
        catch (NativeImage.NativeImageError e) {
            return path;
        }
    }

    void printOptions(Consumer<String> println) {
        this.apiOptions.entrySet().stream().filter(e -> !((OptionInfo)e.getValue()).isDeprecated()).forEach(e -> SubstrateOptionsParser.printOption((Consumer)println, (String)((String)e.getKey()), (String)((OptionInfo)e.getValue()).helpText, (int)4, (int)22, (int)66));
    }

    static final class OptionInfo {
        final String builderOption;
        final String defaultValue;
        final String helpText;
        final boolean hasPathArguments;
        final boolean defaultFinal;
        final String deprecationWarning;
        final List<Function<Object, Object>> valueTransformers;

        OptionInfo(String builderOption, String defaultValue, String helpText, boolean hasPathArguments, boolean defaultFinal, String deprecationWarning, List<Function<Object, Object>> valueTransformers) {
            this.builderOption = builderOption;
            this.defaultValue = defaultValue;
            this.helpText = helpText;
            this.hasPathArguments = hasPathArguments;
            this.defaultFinal = defaultFinal;
            this.deprecationWarning = deprecationWarning;
            this.valueTransformers = valueTransformers;
        }

        boolean isDeprecated() {
            return this.deprecationWarning.length() > 0;
        }
    }
}

