/*
 * Decompiled with CFR 0.152.
 */
package com.lostjs.wx4j.context;

import com.lostjs.wx4j.context.WxContext;
import com.lostjs.wx4j.context.WxContextSource;
import com.lostjs.wx4j.transporter.WxTransporter;
import com.lostjs.wx4j.utils.QrCodeUtil;
import com.lostjs.wx4j.utils.WxCodeParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QRCodeWxContextSource
implements WxContextSource {
    public static final int RETRY_LIMIT = 10;
    private static final int TIP_WAIT_SCAN = 1;
    private static final int TIP_WAIT_CONFIRM = 0;
    private Logger LOG = LoggerFactory.getLogger(this.getClass());
    private String uuid;
    private WxTransporter transporter;

    public QRCodeWxContextSource(WxTransporter transporter) {
        this.transporter = transporter;
    }

    public String prepareLogin() {
        this.uuid = this.getUUID();
        return this.getLoginUrl();
    }

    public Optional<String> waitLogin() {
        String url = "https://login.weixin.qq.com/cgi-bin/mmwebwx-bin/login";
        int tip = 1;
        int retryLimit = 10;
        while (retryLimit-- > 0) {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair("tip", String.valueOf(tip)));
            params.add((NameValuePair)new BasicNameValuePair("uuid", this.uuid));
            String response = this.transporter.get(url, params);
            Optional<Integer> codeOpt = WxCodeParser.parse(response);
            if (!codeOpt.isPresent()) continue;
            int code = codeOpt.get();
            if (code == 201) {
                ++retryLimit;
                tip = 0;
                this.LOG.debug("qrcode scanned");
                continue;
            }
            if (code == 408) {
                this.LOG.warn("timeout");
                continue;
            }
            if (code != 200) continue;
            Pattern pattern = Pattern.compile("window.redirect_uri=\"(\\S+?)\";");
            Matcher matcher = pattern.matcher(response);
            if (!matcher.find()) {
                throw new RuntimeException("Invalid response, can not parse redirect_uri, response=" + response);
            }
            String redirectUrl = matcher.group(1) + "&fun=new";
            this.LOG.debug("redirectUrl: {}", (Object)redirectUrl);
            return Optional.of(redirectUrl);
        }
        return Optional.empty();
    }

    public boolean login(String loginUrl) {
        Document document;
        DocumentBuilder builder;
        if (StringUtils.isBlank((CharSequence)loginUrl)) {
            throw new RuntimeException("do waitForLogin first");
        }
        String response = this.transporter.get(loginUrl);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            document = builder.parse(new ByteArrayInputStream(response.getBytes("UTF-8")));
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        String skey = this.getSingleTagContent(document, "skey");
        String sid = this.getSingleTagContent(document, "wxsid");
        String uin = this.getSingleTagContent(document, "wxuin");
        String passTicket = this.getSingleTagContent(document, "pass_ticket");
        WxContext context = this.transporter.getContext();
        context.setBaseUrl(this.getBaseUrl(loginUrl));
        context.setSkey(skey);
        context.setSid(sid);
        context.setUin(uin);
        context.setPassTicket(passTicket);
        this.LOG.debug("wechat auth context: {}", (Object)context.toString());
        return true;
    }

    @Override
    public boolean initWxWebContext() {
        String qrcodeLink = this.prepareLogin();
        String qrcode = QrCodeUtil.genTerminalQrCode(qrcodeLink);
        this.LOG.info("Scan qrcode to login: \n{}", (Object)qrcode);
        Optional<String> loginUrl = this.waitLogin();
        if (!loginUrl.isPresent()) {
            throw new RuntimeException("can't get login url");
        }
        return this.login(loginUrl.get());
    }

    private String getBaseUrl(String loginUrl) {
        URI uri;
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(loginUrl).setCustomQuery(null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String path = uriBuilder.getPath();
        int lastIndex = path.lastIndexOf("/");
        path = path.substring(0, lastIndex);
        uriBuilder.setPath(path);
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri.toString();
    }

    private String getSingleTagContent(Document document, String tagName) {
        NodeList nodes = document.getElementsByTagName(tagName);
        if (nodes.getLength() == 0) {
            throw new RuntimeException(tagName + " not found");
        }
        return nodes.item(0).getTextContent();
    }

    private String getUUID() {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("appid", "wx782c26e4c19acffb"));
        params.add((NameValuePair)new BasicNameValuePair("fun", "new"));
        params.add((NameValuePair)new BasicNameValuePair("lang", "zh_CN"));
        params.add((NameValuePair)new BasicNameValuePair("_", String.valueOf(RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE))));
        String responseBody = this.transporter.get("https://login.weixin.qq.com/jslogin", params);
        Pattern pattern = Pattern.compile("window.QRLogin.code = (\\d+); window.QRLogin.uuid = \"(\\S+?)\"");
        Matcher matcher = pattern.matcher(responseBody);
        int groupCount = matcher.groupCount();
        if (groupCount != 2) {
            throw new RuntimeException("invalid get uuid response, responseBody=" + responseBody);
        }
        boolean found = matcher.find();
        if (!found) {
            throw new RuntimeException("invalid get uuid response, responseBody=" + responseBody);
        }
        String code = matcher.group(1);
        this.LOG.debug("code: {}", (Object)code);
        if (!"200".equals(code)) {
            throw new RuntimeException("invalid get uuid response, responseBody=" + responseBody);
        }
        String uuid = matcher.group(2);
        this.LOG.debug("uuid: {}", (Object)uuid);
        return uuid;
    }

    private String getLoginUrl() {
        if (StringUtils.isBlank((CharSequence)this.uuid)) {
            throw new RuntimeException("prepareLogin first");
        }
        return String.format("https://login.weixin.qq.com/l/%s", this.uuid);
    }
}

