/*
 * Decompiled with CFR 0.152.
 */
package com.lostjs.wx4j.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.lostjs.wx4j.client.WxClient;
import com.lostjs.wx4j.context.WxContext;
import com.lostjs.wx4j.data.SyncResponse;
import com.lostjs.wx4j.data.request.BaseRequest;
import com.lostjs.wx4j.data.request.TinyContact;
import com.lostjs.wx4j.data.response.AddContactResponse;
import com.lostjs.wx4j.data.response.Contact;
import com.lostjs.wx4j.data.response.ContactListResponse;
import com.lostjs.wx4j.data.response.ContactResponse;
import com.lostjs.wx4j.data.response.GroupMember;
import com.lostjs.wx4j.data.response.InitResponse;
import com.lostjs.wx4j.data.response.StatusNotifyResponse;
import com.lostjs.wx4j.data.response.SyncCheckResponse;
import com.lostjs.wx4j.data.response.SyncCheckSelector;
import com.lostjs.wx4j.data.response.SyncKeyContainer;
import com.lostjs.wx4j.data.response.UpdateRemarkNameResponse;
import com.lostjs.wx4j.transporter.WxTransporter;
import com.lostjs.wx4j.utils.WxSyncKeyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicWxClient
implements WxClient {
    private static final int MYSTERIOUS_CODE = 3;
    private static final String API_GET_CONTACT = "/webwxgetcontact";
    private static final String API_BATCH_GET_CONTACT = "/webwxbatchgetcontact";
    private static final String API_STATUS_NOTIFY = "/webwxstatusnotify";
    private static final String API_SYNC = "/webwxsync";
    private static final String API_INIT = "/webwxinit";
    private static final String REQUEST_FIELD_CODE = "Code";
    private static final String REQUEST_FIELD_FROM_USER_NAME = "FromUserName";
    private static final String REQUEST_FIELD_TO_USER_NAME = "ToUserName";
    private static final String REQUEST_FIELD_CLIENT_MESSAGE_ID = "ClientMsgId";
    private static final String REQUEST_FIELD_SYNC_KEY = "SyncKey";
    private static final String REQUEST_FIELD_RANDOM_RANDOM = "rr";
    private static final String REQUEST_FIELD_RANDOM_FOR_PUSH = "r";
    private static final String REQUEST_FIELD_SID_FOR_PUSH = "sid";
    private static final String REQUEST_FIELD_UIN_FOR_PUSH = "uin";
    private static final String REQUEST_FIELD_SKEY_FOR_PUSH = "skey";
    private static final String REQUEST_FIELD_DEVICE_ID_FOR_PUSH = "deviceid";
    private static final String REQUEST_FIELD_SYNC_KEY_FOR_PUSH = "synckey";
    private static final String[] PUSH_HOST_LIST = new String[]{"webpush.weixin.qq.com", "webpush2.weixin.qq.com"};
    private Logger LOG = LoggerFactory.getLogger(this.getClass());
    private WxTransporter transporter;

    @Override
    public void setTransporter(WxTransporter transporter) {
        this.transporter = transporter;
    }

    @Override
    public List<Contact> getContacts() {
        ContactResponse contactResponse = this.transporter.post(API_GET_CONTACT, new TypeReference<ContactResponse>(){});
        return contactResponse.getContacts();
    }

    @Override
    public List<GroupMember> getGroupMembers(String groupUserName) {
        ArrayList<String> userNames = new ArrayList<String>();
        userNames.add(groupUserName);
        List<Contact> contacts = this.getContactsByUserNames(userNames);
        return contacts.get(0).getMemberList();
    }

    @Override
    public List<Contact> getContactsByUserNames(List<String> userNames) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("Count", userNames.size());
        List tinyContacts = userNames.stream().map(n -> {
            TinyContact contact = new TinyContact();
            contact.setUserName((String)n);
            contact.setEncryChatRoomId("");
            return contact;
        }).collect(Collectors.toList());
        dataMap.put("List", tinyContacts);
        ContactListResponse contactList = this.transporter.post(API_BATCH_GET_CONTACT, dataMap, new TypeReference<ContactListResponse>(){});
        return contactList.getContacts();
    }

    @Override
    public void startEventLoop() {
        if (StringUtils.isEmpty((CharSequence)this.getContext().getUserName())) {
            this.init();
        }
        this.LOG.info("check valid comet host");
        String validHost = null;
        SyncCheckResponse checkResponse = null;
        for (String host : PUSH_HOST_LIST) {
            try {
                SyncCheckResponse syncCheckResponse = this.syncComet(host);
                if (syncCheckResponse.getRetcode() != 0) continue;
                checkResponse = syncCheckResponse;
                validHost = host;
            }
            catch (RuntimeException e) {
                this.LOG.error("", (Throwable)e);
            }
        }
        if (checkResponse == null) {
            throw new RuntimeException("sync check error, all comet return error code 1100");
        }
        String finalValidHost = validHost;
        this.LOG.info("valid comet host: {}", validHost);
        new Thread(() -> {
            while (true) {
                SyncCheckResponse syncCheckResponse = null;
                try {
                    syncCheckResponse = this.syncComet(finalValidHost);
                }
                catch (RuntimeException e) {
                    this.LOG.error("exception when sync check", (Throwable)e);
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(3L));
                        continue;
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (syncCheckResponse.getRetcode() != 0) {
                    this.LOG.error("invalid synccheck retcode, retcode=" + syncCheckResponse.getRetcode());
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.LOG.trace("synccheck retcode = {}", (Object)syncCheckResponse.getRetcode());
                }
                try {
                    this.sync();
                    continue;
                }
                catch (RuntimeException e) {
                    this.LOG.error("sync exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }).start();
    }

    @Override
    public String statusNotify() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(REQUEST_FIELD_CODE, 3);
        dataMap.put(REQUEST_FIELD_FROM_USER_NAME, this.getContext().getUserName());
        dataMap.put(REQUEST_FIELD_TO_USER_NAME, this.getContext().getUserName());
        dataMap.put(REQUEST_FIELD_CLIENT_MESSAGE_ID, this.getClientMessageId());
        StatusNotifyResponse statusNotifyResponse = this.transporter.post(API_STATUS_NOTIFY, dataMap, new TypeReference<StatusNotifyResponse>(){});
        return statusNotifyResponse.getMsgId();
    }

    @Override
    public boolean addContact(String userName, String reason) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("Opcode", 2);
        dataMap.put("VerifyContent", reason);
        dataMap.put(REQUEST_FIELD_SKEY_FOR_PUSH, this.getContext().getSkey());
        dataMap.put("VerifyUserListSize", 1);
        ArrayList verifyUserList = new ArrayList();
        HashMap<String, String> verifyUser = new HashMap<String, String>();
        verifyUser.put("Value", userName);
        verifyUser.put("VerifyUserTicket", "");
        verifyUserList.add(verifyUser);
        dataMap.put("VerifyUserList", verifyUserList);
        dataMap.put("SceneListCount", 1);
        dataMap.put("SceneList", Collections.singletonList(33));
        this.transporter.post("/webwxverifyuser", dataMap, new TypeReference<AddContactResponse>(){});
        return true;
    }

    @Override
    public boolean updateRemarkName(String userName, String remarkName) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("CmdId", 2);
        dataMap.put("RemarkName", remarkName);
        dataMap.put("UserName", userName);
        this.transporter.post("/webwxoplog", dataMap, new TypeReference<UpdateRemarkNameResponse>(){});
        return true;
    }

    private long getClientMessageId() {
        return System.currentTimeMillis() / 1000L;
    }

    private void sync() {
        this.LOG.info("sync");
        if (StringUtils.isEmpty((CharSequence)this.getContext().getUserName())) {
            this.init();
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        SyncKeyContainer container = new SyncKeyContainer();
        container.setCount(this.getContext().getSyncKeys().size());
        container.setList(this.getContext().getSyncKeys());
        dataMap.put(REQUEST_FIELD_SYNC_KEY, container);
        dataMap.put(REQUEST_FIELD_RANDOM_RANDOM, System.currentTimeMillis());
        SyncResponse syncResponse = this.transporter.post(API_SYNC, dataMap, new TypeReference<SyncResponse>(){});
        if (syncResponse.getBaseResponse().getRet() == 0) {
            this.getContext().setSyncKeys(syncResponse.getSyncKeyContainer().getList());
        } else {
            this.LOG.warn("sync ret is not 0, ret={}", (Object)syncResponse.getBaseResponse().getRet());
        }
        this.LOG.debug(this.getContext().getSyncKeys().toString());
    }

    private SyncCheckResponse syncComet(String host) {
        this.LOG.trace("sync comet to {}", (Object)host);
        WxContext context = this.getContext();
        BaseRequest baseRequest = new BaseRequest(context);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair(REQUEST_FIELD_SID_FOR_PUSH, baseRequest.getSid()));
        params.add((NameValuePair)new BasicNameValuePair(REQUEST_FIELD_UIN_FOR_PUSH, baseRequest.getUin()));
        params.add((NameValuePair)new BasicNameValuePair(REQUEST_FIELD_DEVICE_ID_FOR_PUSH, baseRequest.getDeviceID()));
        params.add((NameValuePair)new BasicNameValuePair(REQUEST_FIELD_SYNC_KEY_FOR_PUSH, WxSyncKeyUtil.format(context.getSyncKeys())));
        String response = this.transporter.get(this.getPushApi(host), params);
        Pattern pattern = Pattern.compile("window\\.synccheck=\\{retcode:\"(\\d+)\",selector:\"(\\d+)\"\\}");
        Matcher m = pattern.matcher(response);
        if (!m.find()) {
            throw new RuntimeException("unrecognized response, response=" + response);
        }
        int retcode = Integer.parseInt(m.group(1), 10);
        int selector = Integer.parseInt(m.group(2), 10);
        SyncCheckResponse checkResponse = new SyncCheckResponse();
        checkResponse.setRetcode(retcode);
        checkResponse.setSelector(SyncCheckSelector.findByInt(selector));
        return checkResponse;
    }

    private String getPushApi(String host) {
        return "https://" + host + "/cgi-bin/mmwebwx-bin/synccheck";
    }

    private void init() {
        InitResponse initResponse = this.transporter.post(API_INIT, new TypeReference<InitResponse>(){});
        String userName = initResponse.getUser().getUserName();
        this.getContext().setUserName(userName);
        this.getContext().setSyncKeys(initResponse.getSyncKeyContainer().getList());
    }

    private WxContext getContext() {
        return this.transporter.getContext();
    }
}

