/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.utils;

import com.ksyun.ks3.config.Constants;
import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.DateUtils;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.RequestUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthUtils {
    private static final Log log = LogFactory.getLog(AuthUtils.class);
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String calcAuthorization(Authorization auth, Request request) throws SignatureException {
        String signature = AuthUtils.calcSignature(auth.getAccessKeySecret(), request);
        String value = Constants.authHeaderPrefix + " " + auth.getAccessKeyId() + ":" + signature;
        return value;
    }

    public static String calcSignature(String accessKeySecret, String policy) throws SignatureException {
        String signStr = policy;
        log.debug((Object)("StringToSign:" + signStr));
        return AuthUtils.calculateRFC2104HMAC(signStr, accessKeySecret);
    }

    @Deprecated
    public static String getPolicy(Date expiration, String bucket) {
        String policy = "{\"expiration\": \"" + DateUtils.convertDate2Str(expiration, DateUtils.DATETIME_PROTOCOL.ISO8861) + "\",\"conditions\": [ {\"bucket\": \"" + bucket + "\"}]}";
        log.debug((Object)("policy:" + policy));
        try {
            String _policy = new String(Base64.encodeBase64((byte[])policy.getBytes("UTF-8")), "UTF-8");
            return _policy;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String calcSignature(String accessKeySecret, String bucket, String key, Map<String, String> params, String requestMethod, long _signDate) throws SignatureException {
        String paramsToSign = AuthUtils.encodeParams(params);
        String resource = "/" + bucket + "/" + key;
        resource = resource.replace("//", "/%2F");
        if (!StringUtils.isBlank(paramsToSign)) {
            resource = resource + "?" + paramsToSign;
        }
        ArrayList<String> signList = new ArrayList<String>();
        signList.addAll(Arrays.asList(requestMethod, "", "", String.valueOf(_signDate), resource));
        String signStr = StringUtils.join(signList.toArray(), "\n");
        log.debug((Object)("StringToSign:" + signStr.replace("\n", "\\n")));
        return AuthUtils.calculateRFC2104HMAC(signStr, accessKeySecret);
    }

    public static String calcSignature(String accessKeySecret, Request request) throws SignatureException {
        String _signDate;
        String contentType;
        String resource = AuthUtils.CanonicalizedKSSResource(request);
        String requestMethod = request.getMethod().toString();
        String contentMd5 = request.getHeaders().containsKey(HttpHeaders.ContentMD5.toString()) ? request.getHeaders().get(HttpHeaders.ContentMD5.toString()) : "";
        String string = contentType = request.getHeaders().containsKey(HttpHeaders.ContentType.toString()) ? request.getHeaders().get(HttpHeaders.ContentType.toString()) : "";
        if (request.isPresign()) {
            _signDate = String.valueOf(request.getExpires().getTime() / 1000L);
        } else {
            request.addHeaderIfNotContains(HttpHeaders.Date.toString(), DateUtils.convertDate2Str(new Date(), DateUtils.DATETIME_PROTOCOL.RFC1123));
            _signDate = request.getHeaders().get(HttpHeaders.Date.toString());
        }
        ArrayList<String> signList = new ArrayList<String>();
        signList.addAll(Arrays.asList(requestMethod, contentMd5, contentType, _signDate));
        String _headers = AuthUtils.CanonicalizedKSSHeaders(request);
        if (_headers != null && !_headers.equals("")) {
            signList.add(_headers);
        }
        signList.add(resource);
        String signStr = StringUtils.join(signList.toArray(), "\n");
        log.debug((Object)("StringToSign:" + signStr.replace("\n", "\\n")));
        String serverSignature = AuthUtils.calculateRFC2104HMAC(signStr, accessKeySecret);
        return serverSignature;
    }

    public static String CanonicalizedKSSResource(Request request) {
        String queryParams;
        boolean escapeDoubleSlash = true;
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        StringBuffer buffer = new StringBuffer();
        buffer.append("/");
        if (!StringUtils.isBlank(bucketName)) {
            buffer.append(bucketName).append("/");
        }
        if (!StringUtils.isBlank(objectKey)) {
            String encodedPath = HttpUtils.urlEncode(objectKey, true);
            buffer.append(encodedPath);
        }
        String resource = buffer.toString();
        if (escapeDoubleSlash) {
            resource = resource.replace("//", "/%2F");
        }
        if ((queryParams = AuthUtils.encodeParams(request.getQueryParams())) != null && !queryParams.equals("")) {
            resource = resource + "?" + queryParams;
        }
        return resource;
    }

    private static String CanonicalizedKSSHeaders(Request request) {
        String prefix = Constants.specHeaderPrefix;
        Map<String, String> headers = request.getHeaders();
        ArrayList<String> headList = new ArrayList<String>();
        for (String _header : headers.keySet()) {
            if (!_header.toLowerCase().startsWith(prefix)) continue;
            headList.add(_header);
        }
        Collections.sort(headList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < headList.size(); ++i) {
            String _key = (String)headList.get(i);
            buffer.append(((String)headList.get(i)).toLowerCase() + ":" + headers.get(_key));
            if (i >= headList.size() - 1) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String calculateRFC2104HMAC(String data, String key) throws SignatureException {
        String result;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            result = new String(Base64.encodeBase64((byte[])rawHmac), "GBK");
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e);
        }
        return result;
    }

    public static String encodeParams(Map<String, String> params) {
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(params.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        ArrayList<String> kvList = new ArrayList<String>();
        for (Map.Entry entry : arrayList) {
            String value = null;
            String key = ((String)entry.getKey()).replace(String.valueOf('\u200b'), "");
            if (!StringUtils.isBlank((String)entry.getValue())) {
                value = (String)entry.getValue();
            }
            if (!RequestUtils.subResource.contains(entry.getKey()) && !RequestUtils.QueryParam.contains(entry.getKey())) continue;
            if (value != null && !value.equals("")) {
                kvList.add(key + "=" + value);
                continue;
            }
            if (!RequestUtils.subResource.contains(key)) continue;
            kvList.add(key);
        }
        return StringUtils.join(kvList.toArray(), "&");
    }
}

