/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.Ks3ObjectSummary;
import com.ksyun.ks3.dto.ObjectListing;
import com.ksyun.ks3.dto.Owner;
import com.ksyun.ks3.service.response.Ks3WebServiceXmlResponse;
import com.ksyun.ks3.utils.DateUtils;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListObjectsResponse
extends Ks3WebServiceXmlResponse<ObjectListing> {
    private List<Ks3ObjectSummary> objs = null;
    private Ks3ObjectSummary obj = null;
    private Owner owner = null;
    private List<String> prefixs = new ArrayList<String>();

    @Override
    public void startDocument() throws SAXException {
        this.result = new ObjectListing();
        this.objs = new ArrayList<Ks3ObjectSummary>();
        ((ObjectListing)this.result).setCommonPrefixes(this.prefixs);
    }

    @Override
    public void startEle(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String tag = this.getTag();
        if ("Contents".equals(tag)) {
            this.obj = new Ks3ObjectSummary();
        } else if ("Owner".equals(tag)) {
            this.owner = new Owner();
        }
    }

    @Override
    public void endEle(String uri, String localName, String qName) throws SAXException {
        String tag = this.getTag();
        if ("Owner".equals(tag)) {
            this.obj.setOwner(this.owner);
        } else if ("Contents".equals(tag)) {
            this.obj.setBucketName(((ObjectListing)this.result).getBucketName());
            this.objs.add(this.obj);
        } else if ("ListBucketResult".equals(tag)) {
            ((ObjectListing)this.result).setObjectSummaries(this.objs);
        }
    }

    @Override
    public void string(String s) {
        String tag = this.getTag();
        if ("CommonPrefixes".equals(this.getTag(1))) {
            if ("Prefix".equals(tag)) {
                this.prefixs.add(s);
            }
        } else if ("Name".equals(tag)) {
            ((ObjectListing)this.result).setBucketName(s);
        } else if ("Prefix".equals(tag)) {
            ((ObjectListing)this.result).setPrefix(s);
        } else if ("Marker".equals(tag)) {
            ((ObjectListing)this.result).setMarker(s);
        } else if ("MaxKeys".equals(tag)) {
            ((ObjectListing)this.result).setMaxKeys(Integer.parseInt(s));
        } else if ("Delimiter".equals(tag)) {
            ((ObjectListing)this.result).setDelimiter(s);
        } else if ("IsTruncated".equals(tag)) {
            ((ObjectListing)this.result).setTruncated("true".equals(s));
        } else if ("Key".equals(tag)) {
            this.obj.setKey(s);
        } else if ("LastModified".equals(tag)) {
            this.obj.setLastModified(DateUtils.convertStr2Date(s));
        } else if ("ETag".equals(tag)) {
            this.obj.setETag(s);
        } else if ("Size".equals(tag)) {
            this.obj.setSize(Long.parseLong(s));
        } else if ("ID".equals(tag)) {
            this.owner.setId(s);
        } else if ("DisplayName".equals(tag)) {
            this.owner.setDisplayName(s);
        } else if ("StorageClass".equals(tag)) {
            this.obj.setStorageClass(s);
        } else if ("Prefix".equals(tag)) {
            this.prefixs.add(s);
        } else if ("NextMarker".equals(tag)) {
            ((ObjectListing)this.result).setNextMarker(s);
        } else if ("Encoding-Type".equals(tag)) {
            ((ObjectListing)this.result).setEncodingType(s);
        }
    }

    @Override
    public void preHandle() {
    }

    @Override
    public int[] expectedStatus() {
        return new int[]{200};
    }
}

