/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.BucketLoggingStatus;
import com.ksyun.ks3.dto.Grant;
import com.ksyun.ks3.dto.GranteeEmail;
import com.ksyun.ks3.dto.GranteeId;
import com.ksyun.ks3.dto.GranteeUri;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;
import java.io.ByteArrayInputStream;
import java.util.HashSet;

public class PutBucketLoggingRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private BucketLoggingStatus bucketLoggingStatus = new BucketLoggingStatus();

    public PutBucketLoggingRequest(String bucketName, boolean enable, String targetBucket) {
        this(bucketName);
        this.bucketLoggingStatus.setEnable(enable);
        this.bucketLoggingStatus.setTargetBucket(targetBucket);
    }

    public PutBucketLoggingRequest(String bucketName, boolean enable, String targetBucket, String targetPrefix) {
        this(bucketName);
        this.bucketLoggingStatus.setEnable(enable);
        this.bucketLoggingStatus.setTargetBucket(targetBucket);
        this.bucketLoggingStatus.setTargetPrefix(targetPrefix);
    }

    public PutBucketLoggingRequest(String bucketName, BucketLoggingStatus bucketLoggingStatus) {
        this(bucketName);
        this.bucketLoggingStatus = bucketLoggingStatus;
    }

    public PutBucketLoggingRequest(String bucketName) {
        this.bucket = bucketName;
    }

    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (this.bucketLoggingStatus == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketLoggingStatus");
        }
        if (this.bucketLoggingStatus.isEnable() && this.bucketLoggingStatus.getTargetBucket() == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNullInCondition("targetBucket", "enable \u4e3a true");
        }
    }

    public BucketLoggingStatus getBucketLoggingStatus() {
        return this.bucketLoggingStatus;
    }

    public void setBucketLoggingStatus(BucketLoggingStatus bucketLoggingStatus) {
        this.bucketLoggingStatus = bucketLoggingStatus;
    }

    public void setEnable(boolean enable) {
        if (this.bucketLoggingStatus == null) {
            this.bucketLoggingStatus = new BucketLoggingStatus();
        }
        this.bucketLoggingStatus.setEnable(enable);
    }

    public void setTargetBucket(String bucket) {
        if (this.bucketLoggingStatus == null) {
            this.bucketLoggingStatus = new BucketLoggingStatus();
        }
        this.bucketLoggingStatus.setTargetBucket(bucket);
    }

    public void setTargetPrefix(String prefix) {
        if (this.bucketLoggingStatus == null) {
            this.bucketLoggingStatus = new BucketLoggingStatus();
        }
        this.bucketLoggingStatus.setTargetPrefix(prefix);
    }

    public void buildRequest(Request request) {
        request.setBucket(this.bucket);
        request.setMethod(HttpMethod.PUT);
        request.addQueryParam("logging", null);
        XmlWriter writer = new XmlWriter();
        writer.startWithNs("BucketLoggingStatus");
        if (this.bucketLoggingStatus.isEnable()) {
            writer.start("LoggingEnabled").start("TargetBucket").value(this.bucketLoggingStatus.getTargetBucket()).end().start("TargetPrefix").value(this.bucketLoggingStatus.getTargetPrefix()).end();
            if (this.bucketLoggingStatus.getTargetGrants() != null && this.bucketLoggingStatus.getTargetGrants().size() != 0) {
                HashSet<Grant> grants = this.bucketLoggingStatus.getTargetGrants();
                for (Grant grant : grants) {
                    writer.start("Grant");
                    if (grant.getGrantee() instanceof GranteeEmail) {
                        writer.start("Grantee", new String[]{"xmlns:xsi", "xsi"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "AmazonCustomerByEmail"});
                        writer.start("EmailAddress");
                    } else if (grant.getGrantee() instanceof GranteeUri) {
                        writer.start("Grantee", new String[]{"xmlns:xsi", "xsi"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "Group"});
                        writer.start("URI");
                    } else if (grant.getGrantee() instanceof GranteeId) {
                        writer.start("Grantee", new String[]{"xmlns:xsi", "xsi"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "CanonicalUser"});
                        writer.start("ID");
                    }
                    writer.value(grant.getGrantee().getIdentifier()).end().end().start("Permission").value(grant.getPermission().toString()).end();
                    writer.end();
                }
            }
            writer.end().end();
        } else {
            writer.end();
        }
        request.setContent(new ByteArrayInputStream(writer.toString().getBytes()));
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }
}

