/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.ksyun.ks3.dto.BucketLifecycleConfiguration;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.DateUtils;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.List;

public class PutBucketLifecycleRequest
extends Ks3WebServiceRequest {
    private String bucketName;
    private BucketLifecycleConfiguration lifecycleConfiguration;

    public PutBucketLifecycleRequest(String bucketName, BucketLifecycleConfiguration lifecycleConfiguration) {
        this.bucketName = bucketName;
        this.lifecycleConfiguration = lifecycleConfiguration;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public BucketLifecycleConfiguration getLifecycleConfiguration() {
        return this.lifecycleConfiguration;
    }

    public void setLifecycleConfiguration(BucketLifecycleConfiguration lifecycleConfiguration) {
        this.lifecycleConfiguration = lifecycleConfiguration;
    }

    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucketName);
        request.addQueryParam("lifecycle", "");
        XmlWriter writer = new XmlWriter();
        writer.start("LifecycleConfiguration");
        List<BucketLifecycleConfiguration.Rule> rules = this.lifecycleConfiguration.getRules();
        for (BucketLifecycleConfiguration.Rule rule : rules) {
            writer.start("Rule");
            writer.start("ID").value(rule.getId()).end();
            writer.start("Filter");
            writer.start("Prefix").value(rule.getPrefix()).end();
            writer.end();
            writer.start("Status").value(rule.getStatus().status2Str()).end();
            writer.start("Expiration");
            if (rule.getExpirationDate() != null) {
                writer.start("Date").value(PutBucketLifecycleRequest.getISO8601Timestamp(rule.getExpirationDate())).end();
            } else if (rule.getExpirationInDays() > 0) {
                writer.start("Days").value(rule.getExpirationInDays()).end();
            }
            writer.end();
            writer.end();
        }
        writer.end();
        String xml = writer.toString();
        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(xml.getBytes()));
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
    }

    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (this.lifecycleConfiguration == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("lifecycleConfiguration");
        }
        if (this.lifecycleConfiguration.getRules() == null || this.lifecycleConfiguration.getRules().size() == 0) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketCorsConfiguration.rules");
        }
        if (this.lifecycleConfiguration.getRules().size() > 100) {
            throw ClientIllegalArgumentExceptionGenerator.between("lifecycleConfiguration.rules.size()", String.valueOf(this.lifecycleConfiguration.getRules().size()), "0", String.valueOf(100));
        }
        List<BucketLifecycleConfiguration.Rule> rules = this.lifecycleConfiguration.getRules();
        for (BucketLifecycleConfiguration.Rule rule : rules) {
            rule.validate();
        }
    }

    public static String getISO8601Timestamp(Date date) {
        return ISO8601Utils.format((Date)DateUtils.truncateToDay(date));
    }
}

