/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.dto;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.utils.StringUtils;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketLifecycleConfiguration {
    private List<Rule> rules;

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public BucketLifecycleConfiguration(List<Rule> rules) {
        this.rules = rules;
    }

    public BucketLifecycleConfiguration() {
    }

    public String toString() {
        return "BucketLifecycleConfiguration(rules=" + this.getRules() + ")";
    }

    public static class Rule {
        private String id;
        private String prefix;
        private Status status;
        private Integer expirationInDays;
        private Date expirationDate;

        public void setId(String id) {
            this.id = id;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setExpirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
        }

        public String getId() {
            return this.id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Integer getExpirationInDays() {
            return this.expirationInDays;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public String toString() {
            return "BucketLifecycleConfiguration.Rule(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", status=" + (Object)((Object)this.getStatus()) + ", expirationInDays=" + this.getExpirationInDays() + ", expirationDate=" + this.getExpirationDate();
        }

        public void validate() throws ClientIllegalArgumentException {
            this.validateRuleId();
            this.validateExpiration();
            this.validateStatus();
        }

        private void validateRuleId() throws ClientIllegalArgumentException {
            if (StringUtils.isBlank(this.id)) {
                throw ClientIllegalArgumentExceptionGenerator.notNull("rule id");
            }
            if (this.id.length() > 255) {
                throw ClientIllegalArgumentExceptionGenerator.between("rule id", this.id, "1", String.valueOf(255));
            }
        }

        private void validateFilter() throws ClientIllegalArgumentException {
            if (this.prefix == null) {
                throw ClientIllegalArgumentExceptionGenerator.notNull("prefix");
            }
        }

        private void validateExpiration() throws ClientIllegalArgumentException {
            if (this.expirationInDays == null && this.expirationDate == null) {
                throw ClientIllegalArgumentExceptionGenerator.notNull("expirationInDays", "expirationDate");
            }
            if (this.expirationInDays != null && this.expirationDate != null) {
                throw new ClientIllegalArgumentException("conflict expirationInDays date and expirationDate");
            }
            if (this.expirationInDays != null && (this.expirationInDays < 1 || this.expirationInDays > 10000)) {
                throw ClientIllegalArgumentExceptionGenerator.between("expirationInDays", String.valueOf(this.expirationInDays), String.valueOf(1), String.valueOf(10000));
            }
        }

        private void validateStatus() throws ClientIllegalArgumentException {
            if (this.status == null) {
                throw ClientIllegalArgumentExceptionGenerator.notNull("status");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ENABLED("Enabled"),
        DISABLED("Disabled");

        private String status;

        private Status(String status) {
            this.status = status;
        }

        public String status2Str() {
            return this.status;
        }

        public static Status str2Status(String statusStr) {
            Status status = null;
            for (Status senum : Status.values()) {
                if (!senum.status.equals(statusStr)) continue;
                status = senum;
                break;
            }
            return status;
        }
    }
}

