/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.encryption;

import com.ksyun.ks3.dto.CompleteMultipartUploadResult;
import com.ksyun.ks3.dto.CopyResult;
import com.ksyun.ks3.dto.GetObjectResult;
import com.ksyun.ks3.dto.InitiateMultipartUploadResult;
import com.ksyun.ks3.dto.PartETag;
import com.ksyun.ks3.dto.PutObjectResult;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.Ks3ServiceException;
import com.ksyun.ks3.exception.serviceside.NoSuchKeyException;
import com.ksyun.ks3.service.Ks3Client;
import com.ksyun.ks3.service.Ks3ClientConfig;
import com.ksyun.ks3.service.encryption.S3Direct;
import com.ksyun.ks3.service.encryption.internal.CryptoModuleDispatcher;
import com.ksyun.ks3.service.encryption.internal.EncryptionUtils;
import com.ksyun.ks3.service.encryption.internal.S3CryptoModule;
import com.ksyun.ks3.service.encryption.model.CryptoConfiguration;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterials;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterialsProvider;
import com.ksyun.ks3.service.encryption.model.StaticEncryptionMaterialsProvider;
import com.ksyun.ks3.service.request.AbortMultipartUploadRequest;
import com.ksyun.ks3.service.request.CompleteMultipartUploadRequest;
import com.ksyun.ks3.service.request.CopyObjectRequest;
import com.ksyun.ks3.service.request.CopyPartRequest;
import com.ksyun.ks3.service.request.DeleteObjectRequest;
import com.ksyun.ks3.service.request.GetObjectRequest;
import com.ksyun.ks3.service.request.InitiateMultipartUploadRequest;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.service.request.UploadPartRequest;

public class Ks3EncryptionClient
extends Ks3Client {
    private final S3CryptoModule<?> crypto;

    public Ks3EncryptionClient(String accesskeyid, String accesskeysecret, EncryptionMaterials encryptionMaterials) {
        this(accesskeyid, accesskeysecret, new StaticEncryptionMaterialsProvider(encryptionMaterials));
    }

    public Ks3EncryptionClient(String accesskeyid, String accesskeysecret, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this(accesskeyid, accesskeysecret, encryptionMaterialsProvider, new CryptoConfiguration(), new Ks3ClientConfig());
    }

    public Ks3EncryptionClient(String accesskeyid, String accesskeysecret, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig, Ks3ClientConfig ks3config) {
        this(accesskeyid, accesskeysecret, new StaticEncryptionMaterialsProvider(encryptionMaterials), cryptoConfig, ks3config);
    }

    public Ks3EncryptionClient(String accesskeyid, String accesskeysecret, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        this(accesskeyid, accesskeysecret, new StaticEncryptionMaterialsProvider(encryptionMaterials), cryptoConfig, new Ks3ClientConfig());
    }

    public Ks3EncryptionClient(String accesskeyid, String accesskeysecret, EncryptionMaterialsProvider kekMaterialsProvider, CryptoConfiguration cryptoConfig, Ks3ClientConfig ks3config) {
        super(accesskeyid, accesskeysecret);
        this.assertParameterNotNull(kekMaterialsProvider, "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(cryptoConfig, "CryptoConfiguration parameter must not be null.");
        this.crypto = new CryptoModuleDispatcher(new S3DirectImpl(), kekMaterialsProvider, cryptoConfig);
        this.setKs3config(ks3config);
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public PutObjectResult putObject(PutObjectRequest req) {
        return this.crypto.putObjectSecurely(req);
    }

    public GetObjectResult getObject(GetObjectRequest req) {
        return this.crypto.getObjectSecurely(req);
    }

    public void deleteObject(DeleteObjectRequest req) {
        req.getRequestConfig().setUserAgent("ks3-kss-java-sdk/ks3encryptionclient/v0.8.2");
        super.deleteObject(req);
        DeleteObjectRequest instructionDeleteRequest = EncryptionUtils.createInstructionDeleteObjectRequest(req);
        try {
            super.deleteObject(instructionDeleteRequest);
        }
        catch (NoSuchKeyException noSuchKeyException) {
            // empty catch block
        }
    }

    public CopyResult copyObject(CopyObjectRequest req) {
        req.getRequestConfig().setUserAgent("ks3-kss-java-sdk/ks3encryptionclient/v0.8.2");
        if (super.objectExists(req.getDestinationBucket(), req.getDestinationKey())) {
            throw new Ks3ClientException("copy faild,destination key exists!");
        }
        boolean copyinstruction = false;
        if (super.objectExists(req.getSourceBucket(), req.getSourceKey() + ".instruction")) {
            if (super.objectExists(req.getDestinationBucket(), req.getDestinationKey() + ".instruction")) {
                throw new Ks3ClientException("copy faild,destination instruction file exists");
            }
            copyinstruction = true;
        }
        if (copyinstruction) {
            super.copyObject(req.getDestinationBucket(), req.getDestinationKey() + ".instruction", req.getSourceBucket(), req.getSourceKey() + ".instruction");
        }
        return super.copyObject(req);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest req) {
        return this.crypto.completeMultipartUploadSecurely(req);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest req) {
        return this.crypto.initiateMultipartUploadSecurely(req);
    }

    public PartETag uploadPart(UploadPartRequest uploadPartRequest) throws Ks3ClientException, Ks3ServiceException {
        return this.crypto.uploadPartSecurely(uploadPartRequest);
    }

    public CopyResult copyPart(CopyPartRequest copyPartRequest) {
        return this.crypto.copyPartSecurely(copyPartRequest);
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest req) {
        this.crypto.abortMultipartUploadSecurely(req);
    }

    private final class S3DirectImpl
    extends S3Direct {
        private S3DirectImpl() {
        }

        public PutObjectResult putObject(PutObjectRequest req) {
            return Ks3EncryptionClient.super.putObject(req);
        }

        public GetObjectResult getObject(GetObjectRequest req) {
            return Ks3EncryptionClient.super.getObject(req);
        }

        public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest req) {
            return Ks3EncryptionClient.super.completeMultipartUpload(req);
        }

        public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest req) {
            return Ks3EncryptionClient.super.initiateMultipartUpload(req);
        }

        public PartETag uploadPart(UploadPartRequest req) throws Ks3ClientException, Ks3ServiceException {
            return Ks3EncryptionClient.super.uploadPart(req);
        }

        public CopyResult copyPart(CopyPartRequest req) {
            return Ks3EncryptionClient.super.copyPart(req);
        }

        public void abortMultipartUpload(AbortMultipartUploadRequest req) {
            Ks3EncryptionClient.super.abortMultipartUpload(req);
        }
    }
}

