/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http;

import com.ksyun.ks3.MD5DigestCalculatingInputStream;
import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.Ks3ServiceException;
import com.ksyun.ks3.exception.client.CallRemoteFailException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentException;
import com.ksyun.ks3.exception.client.ClientInvalidDigestException;
import com.ksyun.ks3.http.HttpClientFactory;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.http.RequestBuilder;
import com.ksyun.ks3.service.Ks3ClientConfig;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.response.Ks3WebServiceResponse;
import com.ksyun.ks3.utils.Base64;
import com.ksyun.ks3.utils.Converter;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ks3CoreController {
    private static final Log log = LogFactory.getLog(Ks3CoreController.class);
    private HttpClientFactory factory = new HttpClientFactory();
    private HttpClient client = null;

    public <X extends Ks3WebServiceResponse<Y>, Y> Y execute(Ks3WebServiceRequest request, Class<X> clazz) {
        return this.execute(new Ks3ClientConfig(), null, request, clazz);
    }

    public <X extends Ks3WebServiceResponse<Y>, Y> Y execute(Authorization auth, Ks3WebServiceRequest request, Class<X> clazz) {
        return this.execute(new Ks3ClientConfig(), auth, request, clazz);
    }

    public <X extends Ks3WebServiceResponse<Y>, Y> Y execute(Ks3ClientConfig ks3config, Authorization auth, Ks3WebServiceRequest request, Class<X> clazz) {
        if (request == null) {
            throw new Ks3ClientException("request can not be null");
        }
        log.debug((Object)("Ks3WebServiceRequest:" + request.getClass() + ";Ks3WebServiceResponse:" + clazz));
        if (ks3config == null) {
            ks3config = new Ks3ClientConfig();
        }
        if (this.client == null) {
            this.client = this.factory.createHttpClient(ks3config.getHttpClientConfig());
        }
        Y result = null;
        try {
            if (!ks3config.isAllowAnonymous() && (auth == null || StringUtils.isBlank(auth.getAccessKeyId()) || StringUtils.isBlank(auth.getAccessKeySecret()))) {
                throw new Ks3ClientException("AccessKeyId or AccessKeySecret can't be null");
            }
            if (request == null || clazz == null) {
                throw new IllegalArgumentException();
            }
            Y y = result = (Y)this.doExecute(ks3config, auth, request, clazz);
            return y;
        }
        catch (RuntimeException e22) {
            Ks3ClientException e22;
            if (!(e22 instanceof Ks3ClientException)) {
                if (e22 instanceof IllegalArgumentException) {
                    ClientIllegalArgumentException ce = new ClientIllegalArgumentException(e22.getMessage());
                    ce.setStackTrace(e22.getStackTrace());
                    e22 = ce;
                } else {
                    e22 = new Ks3ClientException(e22);
                }
            }
            log.warn((Object)e22);
            throw e22;
        }
        finally {
            request.onFinally();
        }
    }

    private <X extends Ks3WebServiceResponse<Y>, Y> Y doExecute(Ks3ClientConfig ks3config, Authorization auth, Ks3WebServiceRequest request, Class<X> clazz) {
        Timer.start();
        HttpResponse response = null;
        Request req = new Request();
        RequestBuilder.buildRequest(request, req, auth, ks3config);
        HttpRequestBase httpRequest = RequestBuilder.buildHttpRequest(request, req, auth, ks3config);
        Ks3WebServiceResponse ksResponse = null;
        try {
            ksResponse = (Ks3WebServiceResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new Ks3ClientException("to instantiate " + clazz + " has occured an exception:(" + e + ")", e);
        }
        catch (IllegalAccessException e) {
            throw new Ks3ClientException("to instantiate " + clazz + " has occured an exception:(" + e + ")", e);
        }
        try {
            try {
                response = this.requestKs3(httpRequest, ks3config);
            }
            catch (Exception e) {
                throw new CallRemoteFailException(e);
            }
            finally {
                log.debug((Object)("finished send request to ks3 service and recive response from the service : " + Timer.end()));
            }
            ksResponse.setHttpRequest((HttpRequest)httpRequest);
            ksResponse.setHttpResponse(response);
            if (!this.success(ksResponse)) {
                throw new Ks3ServiceException(response, StringUtils.join(ksResponse.expectedStatus(), ",")).convert(ksResponse.getRequestId());
            }
            Object result = ksResponse.handleResponse();
            Map<String, String> ret = this.skipMD5Check(response, req);
            if (ret.size() == 2) {
                log.debug((Object)("returned etag is:" + ret.get("ETag")));
                if (!ret.get("ETag").equals(Converter.MD52ETag(ret.get("MD5")))) {
                    throw new ClientInvalidDigestException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by KS3.  You may need to delete the data stored in KS3.");
                }
            } else {
                log.debug((Object)"client MD5 check skipped");
            }
            log.debug((Object)("finished handle response : " + Timer.end()));
            Object t = result;
            return (Y)t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            ksResponse.onFinally();
            log.debug((Object)("finished execute : " + Timer.end()));
        }
    }

    private boolean success(Ks3WebServiceResponse<?> kscResponse) {
        int num = kscResponse.expectedStatus().length;
        int code = kscResponse.getHttpResponse().getStatusLine().getStatusCode();
        for (int i = 0; i < num; ++i) {
            if (code != kscResponse.expectedStatus()[i]) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> skipMD5Check(HttpResponse rep, Request req) {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream content = req.getContent();
        if (content == null || !(content instanceof MD5DigestCalculatingInputStream)) {
            return map;
        }
        String clientmd5 = Base64.encodeAsString(((MD5DigestCalculatingInputStream)content).getMd5Digest());
        Header etagHeader = rep.getFirstHeader(HttpHeaders.ETag.toString());
        if (etagHeader == null) {
            return map;
        }
        String etag = etagHeader.getValue();
        if (StringUtils.isBlank(etag) || StringUtils.isBlank(clientmd5)) {
            return map;
        }
        map.put("ETag", etag);
        map.put("MD5", clientmd5);
        return map;
    }

    private void restRequest(HttpRequest req) throws IllegalStateException, IOException {
        InputStream input;
        HttpEntity entity = null;
        if (req instanceof HttpPut) {
            entity = ((HttpPut)req).getEntity();
        } else if (req instanceof HttpPost) {
            entity = ((HttpPost)req).getEntity();
        }
        if (entity != null && (input = entity.getContent()) != null && input.markSupported()) {
            input.reset();
            input.mark(-1);
        }
    }

    private HttpResponse requestKs3(HttpRequestBase httpRequest, Ks3ClientConfig ks3config) throws ClientProtocolException, IOException, URISyntaxException {
        String location;
        HttpResponse response = null;
        log.info((Object)httpRequest.getRequestLine());
        for (Header header : httpRequest.getAllHeaders()) {
            log.info((Object)("Request Header->" + header.getName() + ":" + header.getValue()));
        }
        response = this.client.execute((HttpUriRequest)httpRequest);
        log.info((Object)response.getStatusLine());
        for (Header header : response.getAllHeaders()) {
            log.info((Object)("Response Header->" + header.getName() + ":" + header.getValue()));
        }
        if (response.getStatusLine().getStatusCode() >= 300 && response.getStatusLine().getStatusCode() < 400 && response.containsHeader("Location") && ks3config.isFlowRedirect() && (location = response.getHeaders("Location")[0].getValue()).startsWith("http")) {
            this.closeResponse(response);
            log.debug((Object)("returned " + response.getStatusLine().getStatusCode() + ",retry request to " + location));
            this.restRequest((HttpRequest)httpRequest);
            httpRequest.setURI(new URI(location));
            response = this.client.execute((HttpUriRequest)httpRequest);
            log.info((Object)response.getStatusLine());
            for (Header header : response.getAllHeaders()) {
                log.info((Object)("Response Header->" + header.getName() + ":" + header.getValue()));
            }
        }
        return response;
    }

    private void closeResponse(HttpResponse httpResponse) {
        block6: {
            try {
                if (httpResponse == null) {
                    return;
                }
                HttpEntity entity = httpResponse.getEntity();
                if (entity == null) break block6;
                InputStream input = null;
                try {
                    input = entity.getContent();
                }
                catch (IllegalStateException e) {
                    input = null;
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {
                log.error((Object)"close httpRequest error");
            }
        }
    }
}

