/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.dto;

import com.ksyun.ks3.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseHeaderOverrides {
    private Map<String, String> overrides = new HashMap<String, String>();

    public void setContentType(String value) {
        this.overrides.put("response-content-type", value);
    }

    public void setContentLanguage(String value) {
        this.overrides.put("response-content-language", value);
    }

    public void setExpires(Date value) {
        SimpleDateFormat sdf = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = sdf.format(value);
        this.overrides.put("response-expires", date);
    }

    public void setCacheControl(String value) {
        this.overrides.put("response-cache-control", value);
    }

    public void setContentDisposition(String value) {
        this.overrides.put("response-content-disposition", value);
    }

    public void setContentEncoding(String value) {
        this.overrides.put("response-content-encoding", value);
    }

    public Map<String, String> getOverrides() {
        return this.overrides;
    }

    public String toString() {
        return StringUtils.object2string(this);
    }
}

