/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.signer;

import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.signer.Signer;
import com.ksyun.ks3.utils.AuthUtils;

public class DefaultSigner
implements Signer {
    public void sign(Authorization auth, Request request) {
        try {
            if (!request.isPresign()) {
                request.addHeader("Authorization".toString(), AuthUtils.calcAuthorization(auth, request));
            } else {
                request.getQueryParams().put("AccessKeyId", auth.getAccessKeyId());
                request.getQueryParams().put("Signature", AuthUtils.calcSignature(auth.getAccessKeySecret(), request));
                request.getQueryParams().put("Expires", String.valueOf(request.getExpires().getTime() / 1000L));
            }
        }
        catch (Exception e) {
            throw new Ks3ClientException("\u8ba1\u7b97\u7528\u6237\u7b7e\u540d\u65f6\u51fa\u9519(" + e + ")", e);
        }
    }
}

