/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.Ks3Result;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ks3WebServiceResponse<T>
extends DefaultHandler {
    private HttpRequest httpRequest;
    private HttpResponse httpResponse;

    protected abstract T abstractHandleResponse();

    public T handleResponse() {
        T ret = this.abstractHandleResponse();
        if (ret instanceof Ks3Result) {
            ((Ks3Result)ret).setRequestId(this.getRequestId());
            ((Ks3Result)ret).setOriginRequest(this.httpRequest);
            ((Ks3Result)ret).setOriginResponse(this.httpResponse);
        }
        return ret;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    protected Header[] getHeaders(String key) {
        return this.httpResponse.getHeaders(key);
    }

    protected String getHeader(String key) {
        Header[] headers = this.getHeaders(key);
        if (headers.length > 0) {
            return headers[0].getValue();
        }
        return "";
    }

    protected InputStream getContent() {
        try {
            return this.httpResponse.getEntity().getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Ks3ClientException("\u65e0\u6cd5\u8bfb\u53d6http response\u7684body(" + e + ")", e);
        }
    }

    public String getRequestId() {
        return this.getHeader(HttpHeaders.RequestId.toString());
    }

    protected void closeRequestInputStream() throws IOException {
        InputStream input;
        if (this.httpRequest == null) {
            return;
        }
        HttpEntity entity = null;
        if (this.httpRequest instanceof HttpPut) {
            entity = ((HttpPut)this.httpRequest).getEntity();
        } else if (this.httpRequest instanceof HttpPost) {
            entity = ((HttpPost)this.httpRequest).getEntity();
        }
        if (entity != null && (input = entity.getContent()) != null) {
            input.close();
        }
    }

    protected void closeResponseInputStream() throws IOException {
        if (this.httpResponse == null) {
            return;
        }
        HttpEntity entity = this.httpResponse.getEntity();
        if (entity != null) {
            InputStream input = null;
            try {
                input = entity.getContent();
            }
            catch (IllegalStateException e) {
                input = null;
            }
            if (input != null) {
                input.close();
            }
        }
    }

    protected void abortRequest() {
        if (this.httpRequest != null && this.httpRequest instanceof HttpRequestBase) {
            ((HttpRequestBase)this.httpRequest).abort();
        }
    }

    public abstract int[] expectedStatus();

    public void onFinally() {
        try {
            this.closeRequestInputStream();
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)("handle response on finally close request inputstream error ," + e.getMessage()));
        }
        try {
            this.closeResponseInputStream();
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)("handle response on finally close response inputstream error ," + e.getMessage()));
        }
        this.abortRequest();
    }
}

