/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.LengthCheckInputStream;
import com.ksyun.ks3.RepeatableFileInputStream;
import com.ksyun.ks3.dto.AccessControlList;
import com.ksyun.ks3.dto.Adp;
import com.ksyun.ks3.dto.CallBackConfiguration;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.SSECustomerKey;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.client.ClientFileNotFoundException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Mimetypes;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.common.StorageClass;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.request.SSECustomerKeyRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutObjectRequest
extends Ks3WebServiceRequest
implements SSECustomerKeyRequest {
    private static final Log log = LogFactory.getLog(PutObjectRequest.class);
    private String bucket;
    private String key;
    private File file;
    private InputStream inputStream;
    private ObjectMetadata objectMeta = new ObjectMetadata();
    private CannedAccessControlList cannedAcl;
    private AccessControlList acl = new AccessControlList();
    private String storageClass;
    private CallBackConfiguration callBackConfiguration;
    private List<Adp> adps = new ArrayList<Adp>();
    private String notifyURL;
    private String redirectLocation;
    private SSECustomerKey sseCustomerKey;

    public PutObjectRequest(String bucketname, String key, File file) {
        this.bucket = bucketname;
        this.key = key;
        this.setFile(file);
    }

    public PutObjectRequest(String bucketname, String key, InputStream inputStream, ObjectMetadata metadata) {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.bucket = bucketname;
        this.key = key;
        this.setObjectMeta(metadata);
        this.inputStream = inputStream;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
        if (this.file == null && this.inputStream == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("file", "inputStream");
        }
        if (!(this.redirectLocation == null || this.redirectLocation.startsWith("/") || this.redirectLocation.startsWith("http://") || this.redirectLocation.startsWith("https://"))) {
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("redirectLocation", this.redirectLocation, "starts with / http:// or  https://");
        }
        if (this.file != null) {
            if (this.file.length() > 0x140000000L) {
                throw ClientIllegalArgumentExceptionGenerator.between("file length ", String.valueOf(this.file.length()), String.valueOf(0), String.valueOf(0x140000000L));
            }
        } else if (this.objectMeta != null && this.objectMeta.getContentLength() > 0x140000000L) {
            throw ClientIllegalArgumentExceptionGenerator.between("Content-Length", String.valueOf(this.objectMeta.getContentLength()), String.valueOf(0), String.valueOf(0x140000000L));
        }
        if (this.callBackConfiguration != null && StringUtils.isBlank(this.callBackConfiguration.getCallBackUrl())) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("callBackConfiguration.callBackUrl");
        }
        if (this.adps != null && this.adps.size() > 0) {
            for (Adp adp : this.adps) {
                if (!StringUtils.isBlank(adp.getCommand())) continue;
                throw ClientIllegalArgumentExceptionGenerator.notNullInCondition("adps.command", "adps is not null");
            }
            if (StringUtils.isBlank(this.notifyURL)) {
                throw ClientIllegalArgumentExceptionGenerator.notNullInCondition("notifyURL", "adps is not null");
            }
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public ObjectMetadata getObjectMeta() {
        return this.objectMeta;
    }

    public void setObjectMeta(ObjectMetadata objectMeta) {
        this.objectMeta = objectMeta;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public CallBackConfiguration getCallBackConfiguration() {
        return this.callBackConfiguration;
    }

    public void setCallBackConfiguration(CallBackConfiguration callBackConfiguration) {
        this.callBackConfiguration = callBackConfiguration;
    }

    public List<Adp> getAdps() {
        return this.adps;
    }

    public void setAdps(List<Adp> adps) {
        this.adps = adps;
    }

    public String getNotifyURL() {
        return this.notifyURL;
    }

    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }

    @Override
    public SSECustomerKey getSseCustomerKey() {
        return this.sseCustomerKey;
    }

    @Override
    public void setSseCustomerKey(SSECustomerKey sseCustomerKey) {
        this.sseCustomerKey = sseCustomerKey;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    @Override
    public void buildRequest(Request request) {
        long length;
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addHeader(HttpHeaders.ContentType, "application/octet-stream");
        if (this.objectMeta == null) {
            this.objectMeta = new ObjectMetadata();
        }
        InputStream input = null;
        if (this.file != null) {
            try {
                input = new RepeatableFileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ClientFileNotFoundException(e);
            }
            if (StringUtils.isBlank(this.objectMeta.getContentType())) {
                this.objectMeta.setContentType(Mimetypes.getInstance().getMimetype(this.file));
            }
            length = this.file.length();
            this.objectMeta.setContentLength(length);
            try {
                String contentMd5_b64 = Md5Utils.md5AsBase64(this.file);
                this.objectMeta.setContentMD5(contentMd5_b64);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw new ClientFileNotFoundException(e);
            }
            catch (IOException e) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw new Ks3ClientException("\u8ba1\u7b97\u6587\u4ef6\u7684MD5\u503c\u51fa\u9519 (" + e + ")", e);
            }
        }
        input = this.inputStream;
        if ((length = this.objectMeta.getContentLength()) > 0L) {
            request.setContent(new LengthCheckInputStream(input, length, false));
        } else {
            request.setContent(input);
        }
        if (StringUtils.isBlank(this.objectMeta.getContentType())) {
            this.objectMeta.setContentType(Mimetypes.getInstance().getMimetype(this.key));
        }
        request.getHeaders().putAll(HttpUtils.convertMeta2Headers(this.objectMeta));
        request.getHeaders().putAll(HttpUtils.convertSSECustomerKey2Headers(this.sseCustomerKey));
        if (this.cannedAcl != null) {
            request.addHeader(HttpHeaders.CannedAcl.toString(), this.cannedAcl.toString());
        }
        if (this.acl != null) {
            request.getHeaders().putAll(HttpUtils.convertAcl2Headers(this.acl));
        }
        if (this.redirectLocation != null) {
            request.addHeader(HttpHeaders.XKssWebsiteRedirectLocation, this.redirectLocation);
        }
        if (this.callBackConfiguration != null) {
            String bodyString;
            request.addHeader(HttpHeaders.XKssCallbackUrl, this.callBackConfiguration.getCallBackUrl());
            StringBuffer body = new StringBuffer();
            if (this.callBackConfiguration.getBodyMagicVariables() != null) {
                for (Map.Entry<String, CallBackConfiguration.MagicVariables> entry : this.callBackConfiguration.getBodyMagicVariables().entrySet()) {
                    body.append(entry.getKey() + "=${" + (Object)((Object)entry.getValue()) + "}&");
                }
            }
            if (this.callBackConfiguration.getBodyKssVariables() != null) {
                for (Map.Entry<String, Object> entry : this.callBackConfiguration.getBodyKssVariables().entrySet()) {
                    body.append(entry.getKey() + "=${kss-" + entry.getKey() + "}&");
                    request.addHeader("kss-" + entry.getKey(), (String)entry.getValue());
                }
            }
            if ((bodyString = body.toString()).endsWith("&")) {
                bodyString = bodyString.substring(0, bodyString.length() - 1);
            }
            request.addHeader(HttpHeaders.XKssCallbackBody, bodyString);
        }
        if (this.storageClass != null) {
            request.addHeader(HttpHeaders.StorageClass, this.storageClass);
        }
        if (this.adps != null && this.adps.size() > 0) {
            request.addHeader(HttpHeaders.AsynchronousProcessingList, URLEncoder.encode(HttpUtils.convertAdps2String(this.adps)));
            if (!StringUtils.isBlank(this.notifyURL)) {
                request.addHeader(HttpHeaders.NotifyURL, HttpUtils.urlEncode(this.notifyURL, false));
            }
        }
    }

    @Override
    public void onFinally() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception e) {
                log.error((Object)("put object on finally close input stream err," + e.getMessage()));
            }
        }
    }
}

