/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.BucketCorsConfiguration;
import com.ksyun.ks3.dto.CorsRule;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;
import java.io.ByteArrayInputStream;
import java.util.List;

public class PutBucketCorsRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private BucketCorsConfiguration bucketCorsConfiguration;

    public PutBucketCorsRequest(String bucketName, BucketCorsConfiguration bucketCorsConfiguration) {
        this.bucket = bucketName;
        this.setBucketCorsConfiguration(bucketCorsConfiguration);
    }

    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (this.bucketCorsConfiguration == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketCorsConfiguration");
        }
        if (this.bucketCorsConfiguration.getRules() == null || this.bucketCorsConfiguration.getRules().size() == 0) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketCorsConfiguration.rules");
        }
        if (this.bucketCorsConfiguration.getRules().size() > 100) {
            throw ClientIllegalArgumentExceptionGenerator.between("bucketCorsConfiguration.rules.size()", String.valueOf(this.bucketCorsConfiguration.getRules().size()), "0", String.valueOf(100));
        }
        List<CorsRule> rules = this.bucketCorsConfiguration.getRules();
        for (CorsRule rule : rules) {
            if (rule.getAllowedMethods() == null || rule.getAllowedMethods().size() == 0) {
                throw ClientIllegalArgumentExceptionGenerator.notNull("bucketCorsConfiguration.rules.allowedMethods");
            }
            if (rule.getAllowedOrigins() != null && rule.getAllowedOrigins().size() != 0) continue;
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketCorsConfiguration.rules.allowedOrigins");
        }
    }

    public BucketCorsConfiguration getBucketCorsConfiguration() {
        return this.bucketCorsConfiguration;
    }

    public void setBucketCorsConfiguration(BucketCorsConfiguration bucketCorsConfiguration) {
        this.bucketCorsConfiguration = bucketCorsConfiguration;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucket);
        request.addQueryParam("cors", "");
        XmlWriter writer = new XmlWriter();
        writer.startWithNs("CORSConfiguration");
        List<CorsRule> rules = this.bucketCorsConfiguration.getRules();
        for (CorsRule rule : rules) {
            writer.start("CORSRule");
            for (CorsRule.AllowedMethods method : rule.getAllowedMethods()) {
                writer.start("AllowedMethod").value(method.toString()).end();
            }
            for (String orgin : rule.getAllowedOrigins()) {
                writer.start("AllowedOrigin").value(orgin).end();
            }
            if (rule.getMaxAgeSeconds() > 0) {
                writer.start("MaxAgeSeconds").value(rule.getMaxAgeSeconds()).end();
            }
            if (rule.getExposedHeaders() != null) {
                for (String header : rule.getExposedHeaders()) {
                    writer.start("ExposeHeader").value(header).end();
                }
            }
            if (rule.getAllowedHeaders() != null) {
                for (String header : rule.getAllowedHeaders()) {
                    writer.start("AllowedHeader").value(header).end();
                }
            }
            writer.end();
        }
        writer.end();
        String xml = writer.toString();
        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(xml.getBytes()));
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
    }
}

