/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.AccessControlList;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.SSECustomerKey;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Mimetypes;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.common.StorageClass;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;

public class InitiateMultipartUploadRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;
    private ObjectMetadata objectMeta = new ObjectMetadata();
    private AccessControlList acl = new AccessControlList();
    private CannedAccessControlList cannedAcl;
    private StorageClass storageClass;
    private String redirectLocation;
    private SSECustomerKey sseCustomerKey;

    public InitiateMultipartUploadRequest(String bucketname, String objectkey) {
        this.bucket = bucketname;
        this.key = objectkey;
    }

    public InitiateMultipartUploadRequest(String bucketname, String objectkey, ObjectMetadata metadata) {
        this.bucket = bucketname;
        this.key = objectkey;
        this.objectMeta = metadata;
    }

    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.validateBucketName(this.bucket) == null) {
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("bucketname", this.bucket, "\u8be6\u89c1API\u6587\u6863");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
        if (!(this.redirectLocation == null || this.redirectLocation.startsWith("/") || this.redirectLocation.startsWith("http://") || this.redirectLocation.startsWith("https://"))) {
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("redirectLocation", this.redirectLocation, "\u4ee5 / http:// \u6216 https://\u5f00\u5934");
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ObjectMetadata getObjectMeta() {
        return this.objectMeta;
    }

    public void setObjectMeta(ObjectMetadata objectMeta) {
        this.objectMeta = objectMeta;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public SSECustomerKey getSseCustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSseCustomerKey(SSECustomerKey sseCustomerKey) {
        this.sseCustomerKey = sseCustomerKey;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.POST);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addHeader(HttpHeaders.ContentType, "binary/octet-stream");
        request.getQueryParams().put("uploads", null);
        if (this.objectMeta == null) {
            this.objectMeta = new ObjectMetadata();
        }
        if (StringUtils.isBlank(this.objectMeta.getContentType())) {
            this.objectMeta.setContentType(Mimetypes.getInstance().getMimetype(this.key));
        }
        request.getHeaders().putAll(HttpUtils.convertMeta2Headers(this.objectMeta));
        request.getHeaders().putAll(HttpUtils.convertSSECustomerKey2Headers(this.sseCustomerKey));
        if (this.cannedAcl != null) {
            request.addHeader(HttpHeaders.CannedAcl.toString(), this.cannedAcl.toString());
        }
        if (this.acl != null) {
            request.getHeaders().putAll(HttpUtils.convertAcl2Headers(this.acl));
        }
        if (this.redirectLocation != null) {
            request.addHeader(HttpHeaders.XKssWebsiteRedirectLocation, this.redirectLocation);
        }
        if (this.storageClass != null) {
            request.addHeader(HttpHeaders.StorageClass, this.storageClass.toString());
        }
        request.getHeaders().remove((Object)HttpHeaders.ContentLength);
    }
}

