/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.ResponseHeaderOverrides;
import com.ksyun.ks3.dto.SSECustomerKey;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.DateUtils;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetObjectRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;
    private long[] range = null;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private ResponseHeaderOverrides overrides = new ResponseHeaderOverrides();
    private SSECustomerKey sseCustomerKey;

    public GetObjectRequest(String bucketname, String key) {
        this.bucket = bucketname;
        this.key = key;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setRange(long[] range) {
        this.range = range;
    }

    public long[] getRange() {
        return this.range;
    }

    public void setRange(long start, long end) {
        this.range = new long[]{start, end};
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> matchingETagConstraints) {
        this.matchingETagConstraints = matchingETagConstraints;
    }

    public List<String> getNonmatchingEtagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingEtagConstraints(List<String> nonmatchingEtagConstraints) {
        this.nonmatchingEtagConstraints = nonmatchingEtagConstraints;
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date unmodifiedSinceConstraint) {
        this.unmodifiedSinceConstraint = unmodifiedSinceConstraint;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date modifiedSinceConstraint) {
        this.modifiedSinceConstraint = modifiedSinceConstraint;
    }

    public ResponseHeaderOverrides getOverrides() {
        return this.overrides;
    }

    public void setOverrides(ResponseHeaderOverrides overrides) {
        this.overrides = overrides;
    }

    public SSECustomerKey getSseCustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSseCustomerKey(SSECustomerKey sseCustomerKey) {
        this.sseCustomerKey = sseCustomerKey;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        if (this.range != null && this.range.length == 2) {
            request.addHeader(HttpHeaders.Range, "bytes=" + this.range[0] + "-" + this.range[1]);
        }
        if (this.matchingETagConstraints.size() > 0) {
            request.addHeader(HttpHeaders.IfMatch, StringUtils.join(this.matchingETagConstraints, ","));
        }
        if (this.nonmatchingEtagConstraints.size() > 0) {
            request.addHeader(HttpHeaders.IfNoneMatch, StringUtils.join(this.nonmatchingEtagConstraints, ","));
        }
        if (this.unmodifiedSinceConstraint != null) {
            request.addHeader(HttpHeaders.IfUnmodifiedSince, DateUtils.convertDate2Str(this.unmodifiedSinceConstraint, DateUtils.DATETIME_PROTOCOL.RFC1123).toString());
        }
        if (this.modifiedSinceConstraint != null) {
            request.addHeader(HttpHeaders.IfModifiedSince, DateUtils.convertDate2Str(this.modifiedSinceConstraint, DateUtils.DATETIME_PROTOCOL.RFC1123).toString());
        }
        request.getQueryParams().putAll(this.getOverrides().getOverrides());
        request.getHeaders().putAll(HttpUtils.convertSSECustomerKey2Headers(this.sseCustomerKey));
    }
}

