/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.encryption.internal;

import com.ksyun.ks3.AutoAbortInputStream;
import com.ksyun.ks3.dto.Ks3Object;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.service.encryption.internal.ContentCryptoScheme;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class S3ObjectWrapper
implements Closeable {
    private final Ks3Object s3obj;

    S3ObjectWrapper(Ks3Object s3obj) {
        if (s3obj == null) {
            throw new IllegalArgumentException();
        }
        this.s3obj = s3obj;
    }

    ObjectMetadata getObjectMetadata() {
        return this.s3obj.getObjectMetadata();
    }

    void setObjectMetadata(ObjectMetadata metadata) {
        this.s3obj.setObjectMetadata(metadata);
    }

    AutoAbortInputStream getObjectContent() {
        return this.s3obj.getObjectContent();
    }

    void setObjectContent(AutoAbortInputStream objectContent) {
        this.s3obj.setObjectContent(objectContent);
    }

    void setObjectContent(InputStream objectContent) {
        this.s3obj.setObjectContent(objectContent);
    }

    String getBucketName() {
        return this.s3obj.getBucketName();
    }

    void setBucketName(String bucketName) {
        this.s3obj.setBucketName(bucketName);
    }

    String getKey() {
        return this.s3obj.getKey();
    }

    void setKey(String key) {
        this.s3obj.setKey(key);
    }

    String getRedirectLocation() {
        return this.s3obj.getRedirectLocation();
    }

    void setRedirectLocation(String redirectLocation) {
        this.s3obj.setRedirectLocation(redirectLocation);
    }

    public String toString() {
        return this.s3obj.toString();
    }

    final boolean isInstructionFile() {
        ObjectMetadata metadata = this.s3obj.getObjectMetadata();
        return metadata != null && metadata.containsUserMeta(HttpHeaders.CRYPTO_INSTRUCTION_FILE.toString());
    }

    final boolean hasEncryptionInfo() {
        ObjectMetadata metadata = this.s3obj.getObjectMetadata();
        return metadata != null && metadata.containsUserMeta(HttpHeaders.CRYPTO_IV.toString()) && (metadata.containsUserMeta(HttpHeaders.CRYPTO_KEY_V2.toString()) || metadata.containsUserMeta(HttpHeaders.CRYPTO_KEY.toString()));
    }

    String toJsonString() {
        try {
            return S3ObjectWrapper.from(this.s3obj.getObjectContent());
        }
        catch (Exception e) {
            throw new Ks3ClientException("Error parsing JSON: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String from(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            is.close();
        }
        return stringBuilder.toString();
    }

    @Override
    public void close() throws IOException {
        this.s3obj.close();
    }

    Ks3Object getS3Object() {
        return this.s3obj;
    }

    ContentCryptoScheme encryptionSchemeOf(Map<String, String> instructionFile) {
        if (instructionFile != null) {
            String cekAlgo = instructionFile.get(HttpHeaders.CRYPTO_CEK_ALGORITHM.toString());
            return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
        }
        ObjectMetadata meta = this.s3obj.getObjectMetadata();
        String cekAlgo = meta.getUserMeta(HttpHeaders.CRYPTO_CEK_ALGORITHM.toString());
        return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
    }
}

