/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.encryption.internal;

import com.ksyun.ks3.dto.CompleteMultipartUploadResult;
import com.ksyun.ks3.dto.CopyResult;
import com.ksyun.ks3.dto.GetObjectResult;
import com.ksyun.ks3.dto.InitiateMultipartUploadResult;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.PartETag;
import com.ksyun.ks3.dto.PutObjectResult;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.Ks3ServiceException;
import com.ksyun.ks3.service.encryption.S3Direct;
import com.ksyun.ks3.service.encryption.internal.MultipartUploadContext;
import com.ksyun.ks3.service.encryption.internal.S3CryptoModule;
import com.ksyun.ks3.service.encryption.internal.S3CryptoModuleAE;
import com.ksyun.ks3.service.encryption.internal.S3CryptoModuleAEStrict;
import com.ksyun.ks3.service.encryption.internal.S3CryptoModuleEO;
import com.ksyun.ks3.service.encryption.model.CryptoConfiguration;
import com.ksyun.ks3.service.encryption.model.CryptoMode;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterialsProvider;
import com.ksyun.ks3.service.request.AbortMultipartUploadRequest;
import com.ksyun.ks3.service.request.CompleteMultipartUploadRequest;
import com.ksyun.ks3.service.request.CopyPartRequest;
import com.ksyun.ks3.service.request.GetObjectRequest;
import com.ksyun.ks3.service.request.InitiateMultipartUploadRequest;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.service.request.UploadPartRequest;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CryptoModuleDispatcher
extends S3CryptoModule<MultipartUploadContext> {
    private final CryptoMode defaultCryptoMode;
    private final S3CryptoModuleEO eo;
    private final S3CryptoModuleAE ae;

    public CryptoModuleDispatcher(S3Direct s3, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        CryptoMode cryptoMode = cryptoConfig.getCryptoMode();
        this.defaultCryptoMode = cryptoMode == null ? CryptoMode.EncryptionOnly : cryptoMode;
        switch (this.defaultCryptoMode) {
            case StrictAuthenticatedEncryption: {
                this.ae = new S3CryptoModuleAEStrict(s3, encryptionMaterialsProvider, cryptoConfig);
                this.eo = null;
                break;
            }
            case AuthenticatedEncryption: {
                this.ae = new S3CryptoModuleAE(s3, encryptionMaterialsProvider, cryptoConfig);
                this.eo = null;
                break;
            }
            default: {
                this.eo = new S3CryptoModuleEO(s3, encryptionMaterialsProvider, cryptoConfig);
                this.ae = new S3CryptoModuleAE(s3, encryptionMaterialsProvider, cryptoConfig);
            }
        }
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) throws Ks3ClientException, Ks3ServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.putObjectSecurely(putObjectRequest) : this.ae.putObjectSecurely(putObjectRequest);
    }

    @Override
    public GetObjectResult getObjectSecurely(GetObjectRequest req) throws Ks3ClientException, Ks3ServiceException {
        return this.ae.getObjectSecurely(req);
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest req, File destinationFile) throws Ks3ClientException, Ks3ServiceException {
        return this.ae.getObjectSecurely(req, destinationFile);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest req) throws Ks3ClientException, Ks3ServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.completeMultipartUploadSecurely(req) : this.ae.completeMultipartUploadSecurely(req);
    }

    @Override
    public void abortMultipartUploadSecurely(AbortMultipartUploadRequest req) {
        if (this.defaultCryptoMode == CryptoMode.EncryptionOnly) {
            this.eo.abortMultipartUploadSecurely(req);
        } else {
            this.ae.abortMultipartUploadSecurely(req);
        }
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest req) throws Ks3ClientException, Ks3ServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.initiateMultipartUploadSecurely(req) : this.ae.initiateMultipartUploadSecurely(req);
    }

    @Override
    public PartETag uploadPartSecurely(UploadPartRequest req) throws Ks3ClientException, Ks3ServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.uploadPartSecurely(req) : this.ae.uploadPartSecurely(req);
    }

    @Override
    public CopyResult copyPartSecurely(CopyPartRequest req) {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.copyPartSecurely(req) : this.ae.copyPartSecurely(req);
    }
}

