/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;

public class AbortMultipartUploadRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;
    private String uploadId;

    public AbortMultipartUploadRequest(String bucketname, String objectkey, String uploadId) {
        this.bucket = bucketname;
        this.key = objectkey;
        this.setUploadId(uploadId);
    }

    public void validateParams() {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectKey");
        }
        if (StringUtils.isBlank(this.uploadId)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("uploadId");
        }
    }

    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.DELETE);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addQueryParam("uploadId", this.uploadId);
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

