/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.dto;

import com.ksyun.ks3.dto.AccessControlList;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.dto.Grant;
import com.ksyun.ks3.dto.GranteeUri;
import com.ksyun.ks3.dto.Ks3Result;
import com.ksyun.ks3.dto.Owner;
import com.ksyun.ks3.dto.Permission;
import com.ksyun.ks3.utils.StringUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlPolicy
extends Ks3Result {
    private AccessControlList accessControlList = new AccessControlList();
    private Owner owner;

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public Set<Grant> getGrants() {
        return this.accessControlList.getGrants();
    }

    public void setGrants(HashSet<Grant> grants) {
        this.accessControlList.setGrants(grants);
    }

    public String toString() {
        return StringUtils.object2string(this);
    }

    public CannedAccessControlList getCannedAccessControlList() {
        LinkedHashSet<Permission> allUsersPermissions = new LinkedHashSet<Permission>();
        for (Grant grant : this.getGrants()) {
            if (!GranteeUri.AllUsers.equals(grant.getGrantee())) continue;
            allUsersPermissions.add(grant.getPermission());
        }
        boolean read = allUsersPermissions.contains((Object)Permission.Read);
        boolean write = allUsersPermissions.contains((Object)Permission.Write);
        if (read && write) {
            return CannedAccessControlList.PublicReadWrite;
        }
        if (read) {
            return CannedAccessControlList.PublicRead;
        }
        return CannedAccessControlList.Private;
    }
}

