/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.response;

import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.service.response.Ks3WebServiceResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ks3WebServiceXmlResponse<T>
extends DefaultHandler
implements Ks3WebServiceResponse<T> {
    private HttpResponse response;
    protected T result;
    private String buffer = "";
    private List<String> preTags = new ArrayList<String>();

    protected String getTag(int i) {
        if (i < this.preTags.size()) {
            return this.preTags.get(this.preTags.size() - 1 - i);
        }
        return null;
    }

    protected String getTag() {
        return this.getTag(0);
    }

    private void setResponse(HttpResponse response) {
        this.response = response;
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    protected Header[] getHeaders(String key) {
        return this.response.getHeaders(key);
    }

    protected String getHeader(String key) {
        Header[] headers = this.getHeaders(key);
        if (headers.length > 0) {
            return headers[0].getValue();
        }
        return "";
    }

    @Override
    public String getRequestId() {
        return this.getHeader(HttpHeaders.RequestId.toString());
    }

    @Override
    public T handleResponse(HttpRequest request, HttpResponse response) {
        this.setResponse(response);
        this.preHandle();
        InputStream in = null;
        try {
            in = response.getEntity().getContent();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)this);
            T t = this.result;
            return t;
        }
        catch (Exception e) {
            throw new Ks3ClientException("\u5904\u7406http response\u65f6\u51fa\u9519", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (request instanceof HttpRequestBase) {
                ((HttpRequestBase)request).abort();
            }
        }
    }

    public abstract void preHandle();

    @Override
    public abstract void startDocument() throws SAXException;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.string(this.buffer);
        this.buffer = "";
        if (qName.startsWith("ns2:")) {
            qName = qName.substring(4);
        }
        this.preTags.add(qName);
        this.startEle(uri, localName, qName, attributes);
    }

    public abstract void startEle(String var1, String var2, String var3, Attributes var4) throws SAXException;

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.buffer.startsWith("<![CDATA[") && this.buffer.endsWith("]]>")) {
            this.buffer = this.buffer.substring("<![CDATA[".length());
            this.buffer = this.buffer.substring(0, this.buffer.length() - "]]>".length());
        }
        this.string(this.buffer);
        this.buffer = "";
        if (qName.startsWith("ns2:")) {
            qName = qName.substring(4);
        }
        this.endEle(uri, localName, qName);
        if (this.preTags.get(this.preTags.size() - 1).equals(qName)) {
            this.preTags.remove(this.preTags.size() - 1);
        }
    }

    public abstract void endEle(String var1, String var2, String var3) throws SAXException;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.getTag() != null) {
            String content = new String(ch, start, length);
            this.buffer = this.buffer + content;
        }
    }

    public abstract void string(String var1);
}

