/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.response;

import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.service.response.Ks3WebServiceResponse;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ks3WebServiceDefaultResponse<T>
implements Ks3WebServiceResponse<T> {
    protected T result = null;
    protected HttpResponse response;
    protected HttpRequest request;

    @Override
    public T handleResponse(HttpRequest request, HttpResponse response) {
        this.response = response;
        this.request = request;
        this.preHandle();
        this.abortRequest();
        return this.result;
    }

    public abstract void preHandle();

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    protected Header[] getHeaders(String key) {
        return this.response.getHeaders(key);
    }

    protected String getHeader(String key) {
        Header[] headers = this.getHeaders(key);
        if (headers.length > 0) {
            return headers[0].getValue();
        }
        return "";
    }

    protected InputStream getContent() {
        try {
            return this.response.getEntity().getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Ks3ClientException("\u65e0\u6cd5\u8bfb\u53d6http response\u7684body(" + e + ")", e);
        }
    }

    @Override
    public String getRequestId() {
        return this.getHeader(HttpHeaders.RequestId.toString());
    }

    private void abortRequest() {
        if (this.request != null && this.request instanceof HttpRequestBase) {
            ((HttpRequestBase)this.request).abort();
        }
    }
}

