/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;

public class CopyPartRequest
extends Ks3WebServiceRequest {
    private String destinationBucket;
    private String destinationKey;
    private String sourceBucket;
    private String sourceObject;
    private long beginRange;
    private long endRange;
    private int partNumber;
    private String uploadId;

    public CopyPartRequest(String sourceBucket, String sourceObject, String destinationBucket, String destinationObject, long beginRange, long endRange, int partNumber, String uploadId) {
        this.destinationBucket = destinationBucket;
        this.destinationKey = destinationObject;
        this.sourceBucket = sourceBucket;
        this.sourceObject = sourceObject;
        this.beginRange = beginRange;
        this.endRange = endRange;
        this.partNumber = partNumber;
        this.uploadId = uploadId;
    }

    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.sourceBucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("sourceBucket");
        }
        if (StringUtils.isBlank(this.sourceObject)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("sourceObject");
        }
        if (StringUtils.isBlank(this.destinationBucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("destinationBucket");
        }
        if (StringUtils.isBlank(this.destinationKey)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("destinationObject");
        }
        if (this.beginRange < 0L || this.endRange - this.beginRange < 0x500000L || this.endRange - this.beginRange > 0x140000000L) {
            throw ClientIllegalArgumentExceptionGenerator.between("partsize", String.valueOf(this.endRange - this.beginRange), String.valueOf(0x500000L), String.valueOf(0x140000000L));
        }
        if (this.partNumber < 1 || this.partNumber > 10000) {
            throw ClientIllegalArgumentExceptionGenerator.between("partNumber", String.valueOf(this.partNumber), String.valueOf(1), String.valueOf(10000));
        }
        if (StringUtils.isBlank(this.uploadId)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("uploadId");
        }
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public void setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    public String getSourceObject() {
        return this.sourceObject;
    }

    public void setSourceObject(String sourceObject) {
        this.sourceObject = sourceObject;
    }

    public long getBeginRange() {
        return this.beginRange;
    }

    public void setBeginRange(long beginRange) {
        this.beginRange = beginRange;
    }

    public long getEndRange() {
        return this.endRange;
    }

    public void setEndRange(long endRange) {
        this.endRange = endRange;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public void buildRequest(Request request) {
        request.setBucket(this.destinationBucket);
        request.setKey(this.destinationKey);
        request.setMethod(HttpMethod.PUT);
        request.getQueryParams().put("partNumber", String.valueOf(this.partNumber));
        request.getQueryParams().put("uploadId", String.valueOf(this.uploadId));
        request.addHeader(HttpHeaders.XKssCopySource, "/" + this.sourceBucket + "/" + this.sourceObject);
        request.addHeader(HttpHeaders.XKssCopySourceRange, "bytes=" + this.beginRange + "-" + this.endRange);
    }
}

