/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.AccessControlList;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.SSECustomerKey;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;

public class CopyObjectRequest
extends Ks3WebServiceRequest {
    private String destinationBucket;
    private String destinationKey;
    private String sourceBucket;
    private String sourceKey;
    private CannedAccessControlList cannedAcl;
    private AccessControlList accessControlList;
    private ObjectMetadata newObjectMetadata;
    private SSECustomerKey sourceSSECustomerKey;
    private SSECustomerKey destinationSSECustomerKey;

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey) {
        this.destinationBucket = destinationBucket;
        this.destinationKey = destinationObject;
        this.setSourceBucket(sourceBucket);
        this.setSourceKey(sourceKey);
    }

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, CannedAccessControlList cannedAcl) {
        this(destinationBucket, destinationObject, sourceBucket, sourceKey);
        this.setCannedAcl(cannedAcl);
    }

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, AccessControlList accessControlList) {
        this(destinationBucket, destinationObject, sourceBucket, sourceKey);
        this.setAccessControlList(accessControlList);
    }

    public String getDestinationBucket() {
        return this.destinationBucket;
    }

    public void setDestinationBucket(String destinationBucket) {
        this.destinationBucket = destinationBucket;
    }

    public String getDestinationKey() {
        return this.destinationKey;
    }

    public void setDestinationKey(String destinationKey) {
        this.destinationKey = destinationKey;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public void setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public ObjectMetadata getNewObjectMetadata() {
        return this.newObjectMetadata;
    }

    public void setNewObjectMetadata(ObjectMetadata newObjectMetadata) {
        this.newObjectMetadata = newObjectMetadata;
    }

    public SSECustomerKey getSourceSSECustomerKey() {
        return this.sourceSSECustomerKey;
    }

    public void setSourceSSECustomerKey(SSECustomerKey sourceSSECustomerKey) {
        this.sourceSSECustomerKey = sourceSSECustomerKey;
    }

    public SSECustomerKey getDestinationSSECustomerKey() {
        return this.destinationSSECustomerKey;
    }

    public void setDestinationSSECustomerKey(SSECustomerKey destinationSSECustomerKey) {
        this.destinationSSECustomerKey = destinationSSECustomerKey;
    }

    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.destinationBucket);
        request.setKey(this.destinationKey);
        request.addHeader(HttpHeaders.XKssCopySource, "/" + this.getSourceBucket() + "/" + HttpUtils.urlEncode(this.getSourceKey(), true));
        if (this.getCannedAcl() != null) {
            request.addHeader(HttpHeaders.CannedAcl, this.getCannedAcl().toString());
        }
        request.getHeaders().putAll(HttpUtils.convertMeta2Headers(this.newObjectMetadata));
        request.getHeaders().putAll(HttpUtils.convertSSECustomerKey2Headers(this.destinationSSECustomerKey));
        request.getHeaders().putAll(HttpUtils.convertCopySourceSSECustomerKey2Headers(this.sourceSSECustomerKey));
        if (this.accessControlList != null) {
            request.getHeaders().putAll(HttpUtils.convertAcl2Headers(this.accessControlList));
        }
    }

    public void validateParams() {
        if (StringUtils.isBlank(this.sourceBucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("sourceBucket");
        }
        if (StringUtils.isBlank(this.sourceKey)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("sourceKey");
        }
        if (StringUtils.isBlank(this.destinationBucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("destinationBucket");
        }
        if (StringUtils.isBlank(this.destinationKey)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("destinationKey");
        }
    }
}

