/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.encryption.internal;

import com.ksyun.ks3.LengthCheckInputStream;
import com.ksyun.ks3.RepeatableFileInputStream;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.Mimetypes;
import com.ksyun.ks3.service.encryption.S3Direct;
import com.ksyun.ks3.service.encryption.internal.CipherLiteInputStream;
import com.ksyun.ks3.service.encryption.internal.ContentCryptoMaterial;
import com.ksyun.ks3.service.encryption.internal.ContentCryptoScheme;
import com.ksyun.ks3.service.encryption.internal.MultipartUploadContext;
import com.ksyun.ks3.service.encryption.internal.S3CryptoModule;
import com.ksyun.ks3.service.encryption.internal.S3CryptoScheme;
import com.ksyun.ks3.service.encryption.internal.S3KeyWrapScheme;
import com.ksyun.ks3.service.encryption.model.CryptoConfiguration;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterials;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterialsProvider;
import com.ksyun.ks3.service.encryption.model.MaterialsDescriptionProvider;
import com.ksyun.ks3.service.request.AbortMultipartUploadRequest;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.request.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class S3CryptoModuleBase<T extends MultipartUploadContext>
extends S3CryptoModule<T> {
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterialsProvider kekMaterialsProvider;
    protected final CryptoConfiguration cryptoConfig;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final S3CryptoScheme cryptoScheme;
    protected final ContentCryptoScheme contentCryptoScheme;
    protected final Map<String, T> multipartUploadContexts = Collections.synchronizedMap(new HashMap());
    protected final S3Direct s3;

    protected S3CryptoModuleBase(S3Direct s3, EncryptionMaterialsProvider kekMaterialsProvider, CryptoConfiguration cryptoConfig, S3CryptoScheme cryptoScheme) {
        this.kekMaterialsProvider = kekMaterialsProvider;
        this.cryptoConfig = cryptoConfig;
        this.s3 = s3;
        this.cryptoScheme = cryptoScheme;
        this.contentCryptoScheme = cryptoScheme.getContentCryptoScheme();
    }

    protected abstract long ciphertextLength(long var1);

    @Override
    public final void abortMultipartUploadSecurely(AbortMultipartUploadRequest req) {
        this.s3.abortMultipartUpload(req);
        this.multipartUploadContexts.remove(req.getUploadId());
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata metadata, File file, ContentCryptoMaterial instruction) {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (file != null) {
            Mimetypes mimetypes = Mimetypes.getInstance();
            metadata.setContentType(mimetypes.getMimetype(file));
        }
        return instruction.toObjectMetadata(metadata);
    }

    protected final ContentCryptoMaterial createContentCryptoMaterial(Ks3WebServiceRequest req) {
        if (req instanceof MaterialsDescriptionProvider) {
            return this.newContentCryptoMaterial(this.kekMaterialsProvider, ((MaterialsDescriptionProvider)((Object)req)).getMaterialsDescription(), this.cryptoConfig.getCryptoProvider());
        }
        return this.newContentCryptoMaterial(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider());
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Map<String, String> materialsDescription, Provider provider) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials(materialsDescription);
        return this.buildContentCryptoMaterial(kekMaterials, provider);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Provider provider) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials();
        return this.buildContentCryptoMaterial(kekMaterials, provider);
    }

    private ContentCryptoMaterial buildContentCryptoMaterial(EncryptionMaterials kekMaterials, Provider provider) {
        SecretKey cek = this.generateCEK();
        byte[] iv = new byte[this.contentCryptoScheme.getIVLengthInBytes()];
        this.cryptoScheme.getSecureRandom().nextBytes(iv);
        SecuredCEK cekSecured = this.secureCEK(cek, kekMaterials, provider);
        return new ContentCryptoMaterial(kekMaterials.getMaterialsDescription(), cekSecured.encrypted, cekSecured.keyWrapAlgorithm, this.contentCryptoScheme.createCipherLite(cek, iv, 1, provider));
    }

    protected final SecretKey generateCEK() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(this.contentCryptoScheme.getKeyGeneratorAlgorithm());
            generator.init(this.contentCryptoScheme.getKeyLengthInBits(), this.cryptoScheme.getSecureRandom());
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Ks3ClientException("Unable to generate envelope symmetric key:" + e.getMessage(), e);
        }
    }

    protected final SecuredCEK secureCEK(SecretKey toBeEncrypted, EncryptionMaterials materials, Provider cryptoProvider) {
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        S3KeyWrapScheme kwScheme = this.cryptoScheme.getKeyWrapScheme();
        String keyWrapAlgo = kwScheme.getKeyWrapAlgorithm(kek);
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = cryptoProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, cryptoProvider);
                cipher.init(3, kek, this.cryptoScheme.getSecureRandom());
                return new SecuredCEK(cipher.wrap(toBeEncrypted), keyWrapAlgo);
            }
            byte[] toBeEncryptedBytes = toBeEncrypted.getEncoded();
            String algo = kek.getAlgorithm();
            Cipher cipher = cryptoProvider != null ? Cipher.getInstance(algo, cryptoProvider) : Cipher.getInstance(algo);
            cipher.init(1, kek);
            return new SecuredCEK(cipher.doFinal(toBeEncryptedBytes), null);
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to encrypt symmetric key: " + e.getMessage(), e);
        }
    }

    protected final PutObjectRequest wrapWithCipher(PutObjectRequest request, ContentCryptoMaterial cekMaterial) {
        ObjectMetadata metadata = request.getObjectMeta();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (metadata.getContentMD5() != null) {
            metadata.setUserMeta(HttpHeaders.UNENCRYPTED_CONTENT_MD5.toString(), metadata.getContentMD5());
        }
        metadata.setContentMD5(null);
        long plaintextLength = this.plaintextLength(request, metadata);
        if (plaintextLength >= 0L) {
            metadata.setUserMeta(HttpHeaders.UNENCRYPTED_CONTENT_LENGTH.toString(), Long.toString(plaintextLength));
            metadata.setContentLength(this.ciphertextLength(plaintextLength));
        }
        request.setObjectMeta(metadata);
        request.setInputStream(this.newS3CipherLiteInputStream(request, cekMaterial, plaintextLength));
        request.setFile(null);
        return request;
    }

    private CipherLiteInputStream newS3CipherLiteInputStream(PutObjectRequest req, ContentCryptoMaterial cekMaterial, long plaintextLength) {
        try {
            InputStream is = req.getInputStream();
            if (req.getFile() != null) {
                is = new RepeatableFileInputStream(req.getFile());
            }
            if (plaintextLength > -1L) {
                is = new LengthCheckInputStream(is, plaintextLength, false);
            }
            return new CipherLiteInputStream(is, cekMaterial.getCipherLite(), 2048);
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to create cipher input stream: " + e.getMessage(), e);
        }
    }

    protected final long plaintextLength(PutObjectRequest request, ObjectMetadata metadata) {
        long fileLength = -1L;
        long lengthInMeta = request.getObjectMeta().getContentLength();
        if (request.getFile() != null) {
            fileLength = request.getFile().length();
        }
        if (fileLength >= 0L) {
            return fileLength;
        }
        if (lengthInMeta > 0L && request.getInputStream() != null) {
            return lengthInMeta;
        }
        return -1L;
    }

    public final S3CryptoScheme getS3CryptoScheme() {
        return this.cryptoScheme;
    }

    protected final PutObjectRequest upateInstructionPutRequest(PutObjectRequest request, ContentCryptoMaterial cekMaterial) {
        byte[] bytes = cekMaterial.toJsonString().getBytes(Charset.forName("UTF-8"));
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectMetadata metadata = request.getObjectMeta();
        if (metadata == null) {
            metadata = new ObjectMetadata();
            request.setObjectMeta(metadata);
        }
        metadata.setContentLength(bytes.length);
        metadata.setContentMD5(null);
        metadata.setUserMeta(HttpHeaders.CRYPTO_INSTRUCTION_FILE.toString(), request.getKey() + ".instruction");
        request.setKey(request.getKey() + ".instruction");
        request.setObjectMeta(metadata);
        request.setInputStream(is);
        request.setFile(null);
        return request;
    }

    protected final PutObjectRequest createInstructionPutRequest(String bucketName, String key, ContentCryptoMaterial cekMaterial) {
        byte[] bytes = cekMaterial.toJsonString().getBytes(Charset.forName("UTF-8"));
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(bytes.length);
        metadata.setUserMeta(HttpHeaders.CRYPTO_INSTRUCTION_FILE.toString(), key + ".instruction");
        return new PutObjectRequest(bucketName, key + ".instruction", is, metadata);
    }

    final <X extends Ks3WebServiceRequest> X appendUserAgent(X request, String userAgent) {
        request.getRequestConfig().setUserAgent(userAgent);
        return request;
    }

    private static class SecuredCEK {
        final byte[] encrypted;
        final String keyWrapAlgorithm;

        SecuredCEK(byte[] encryptedKey, String keyWrapAlgorithm) {
            this.encrypted = encryptedKey;
            this.keyWrapAlgorithm = keyWrapAlgorithm;
        }
    }
}

