/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.encryption.internal;

import com.ksyun.ks3.AutoAbortInputStream;
import com.ksyun.ks3.InputSubStream;
import com.ksyun.ks3.LengthCheckInputStream;
import com.ksyun.ks3.RepeatableFileInputStream;
import com.ksyun.ks3.dto.Ks3Object;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.Mimetypes;
import com.ksyun.ks3.service.encryption.internal.AdjustedRangeInputStream;
import com.ksyun.ks3.service.encryption.internal.ByteRangeCapturingInputStream;
import com.ksyun.ks3.service.encryption.internal.CipherFactory;
import com.ksyun.ks3.service.encryption.internal.EncryptionInstruction;
import com.ksyun.ks3.service.encryption.internal.JceEncryptionConstants;
import com.ksyun.ks3.service.encryption.internal.RepeatableCipherInputStream;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterials;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterialsAccessor;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterialsProvider;
import com.ksyun.ks3.service.encryption.model.StaticEncryptionMaterialsProvider;
import com.ksyun.ks3.service.request.DeleteObjectRequest;
import com.ksyun.ks3.service.request.GetObjectRequest;
import com.ksyun.ks3.service.request.InitiateMultipartUploadRequest;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.service.request.UploadPartRequest;
import com.ksyun.ks3.utils.Base64;
import com.ksyun.ks3.utils.JSONObject;
import com.ksyun.ks3.utils.Jackson;
import com.ksyun.ks3.utils.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionUtils {
    public static final String INSTRUCTION_SUFFIX = ".instruction";

    @Deprecated
    public static PutObjectRequest encryptRequestUsingMetadata(PutObjectRequest request, EncryptionMaterials materials, Provider cryptoProvider) {
        EncryptionInstruction instruction = EncryptionUtils.generateInstruction(materials, cryptoProvider);
        PutObjectRequest encryptedObjectRequest = EncryptionUtils.encryptRequestUsingInstruction(request, instruction);
        EncryptionUtils.updateMetadataWithEncryptionInstruction(request, instruction);
        return encryptedObjectRequest;
    }

    @Deprecated
    public static Ks3Object decryptObjectUsingMetadata(Ks3Object object, EncryptionMaterials materials, Provider cryptoProvider) {
        EncryptionInstruction instruction = EncryptionUtils.buildInstructionFromObjectMetadata(object, materials, cryptoProvider);
        return EncryptionUtils.decryptObjectUsingInstruction(object, instruction);
    }

    @Deprecated
    public static EncryptionInstruction generateInstruction(EncryptionMaterials materials, Provider cryptoProvider) {
        return EncryptionUtils.generateInstruction(new StaticEncryptionMaterialsProvider(materials), cryptoProvider);
    }

    public static EncryptionInstruction generateInstruction(EncryptionMaterialsProvider materialsProvider, Provider cryptoProvider) {
        return EncryptionUtils.buildInstruction(materialsProvider.getEncryptionMaterials(), cryptoProvider);
    }

    public static EncryptionInstruction generateInstruction(EncryptionMaterialsProvider materialsProvider, Map<String, String> materialsDescription, Provider cryptoProvider) {
        return EncryptionUtils.buildInstruction(materialsProvider.getEncryptionMaterials(materialsDescription), cryptoProvider);
    }

    private static EncryptionInstruction buildInstruction(EncryptionMaterials materials, Provider cryptoProvider) {
        SecretKey envelopeSymmetricKey = EncryptionUtils.generateOneTimeUseSymmetricKey();
        CipherFactory cipherFactory = new CipherFactory(envelopeSymmetricKey, 1, null, cryptoProvider);
        byte[] encryptedEnvelopeSymmetricKey = EncryptionUtils.getEncryptedSymmetricKey(envelopeSymmetricKey, materials, cryptoProvider);
        return new EncryptionInstruction(materials.getMaterialsDescription(), encryptedEnvelopeSymmetricKey, envelopeSymmetricKey, cipherFactory);
    }

    @Deprecated
    public static EncryptionInstruction buildInstructionFromInstructionFile(Ks3Object instructionFile, EncryptionMaterials materials, Provider cryptoProvider) {
        return EncryptionUtils.buildInstructionFromInstructionFile(instructionFile, new StaticEncryptionMaterialsProvider(materials), cryptoProvider);
    }

    public static EncryptionInstruction buildInstructionFromInstructionFile(Ks3Object instructionFile, EncryptionMaterialsProvider materialsProvider, Provider cryptoProvider) {
        JSONObject instructionJSON = EncryptionUtils.parseJSONInstruction(instructionFile);
        String encryptedSymmetricKeyB64 = instructionJSON.getString(HttpHeaders.CRYPTO_KEY.toString());
        String ivB64 = instructionJSON.getString(HttpHeaders.CRYPTO_IV.toString());
        String materialsDescriptionString = instructionJSON.tryGetString(HttpHeaders.MATERIALS_DESCRIPTION.toString());
        Map<String, String> materialsDescription = EncryptionUtils.convertJSONToMap(materialsDescriptionString);
        byte[] encryptedSymmetricKey = Base64.decode(encryptedSymmetricKeyB64);
        byte[] iv = Base64.decode(ivB64);
        if (encryptedSymmetricKey == null || iv == null) {
            throw new Ks3ClientException(String.format("Necessary encryption info not found in the instruction file '%s' in bucket '%s'", instructionFile.getKey(), instructionFile.getBucketName()));
        }
        EncryptionMaterials materials = EncryptionUtils.retrieveOriginalMaterials(materialsDescription, materialsProvider);
        if (materials == null) {
            throw new Ks3ClientException(String.format("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file '%s' in bucket '%s'.", instructionFile.getKey(), instructionFile.getBucketName()));
        }
        SecretKey symmetricKey = EncryptionUtils.getDecryptedSymmetricKey(encryptedSymmetricKey, materials, cryptoProvider);
        CipherFactory cipherFactory = new CipherFactory(symmetricKey, 2, iv, cryptoProvider);
        return new EncryptionInstruction(materialsDescription, encryptedSymmetricKey, symmetricKey, cipherFactory);
    }

    @Deprecated
    public static EncryptionInstruction buildInstructionFromObjectMetadata(Ks3Object object, EncryptionMaterials materials, Provider cryptoProvider) {
        return EncryptionUtils.buildInstructionFromObjectMetadata(object, new StaticEncryptionMaterialsProvider(materials), cryptoProvider);
    }

    public static EncryptionInstruction buildInstructionFromObjectMetadata(Ks3Object object, EncryptionMaterialsProvider materialsProvider, Provider cryptoProvider) {
        ObjectMetadata metadata = object.getObjectMetadata();
        byte[] encryptedSymmetricKeyBytes = EncryptionUtils.getCryptoBytesFromMetadata(HttpHeaders.CRYPTO_KEY.toString(), metadata);
        byte[] initVectorBytes = EncryptionUtils.getCryptoBytesFromMetadata(HttpHeaders.CRYPTO_IV.toString(), metadata);
        String materialsDescriptionString = EncryptionUtils.getStringFromMetadata(HttpHeaders.MATERIALS_DESCRIPTION.toString(), metadata);
        Map<String, String> materialsDescription = EncryptionUtils.convertJSONToMap(materialsDescriptionString);
        if (encryptedSymmetricKeyBytes == null || initVectorBytes == null) {
            throw new Ks3ClientException(String.format("Necessary encryption info not found in the headers of file '%s' in bucket '%s'", object.getKey(), object.getBucketName()));
        }
        EncryptionMaterials materials = EncryptionUtils.retrieveOriginalMaterials(materialsDescription, materialsProvider);
        if (materials == null) {
            throw new Ks3ClientException(String.format("Unable to retrieve the encryption materials that originally encrypted file '%s' in bucket '%s'.", object.getKey(), object.getBucketName()));
        }
        SecretKey symmetricKey = EncryptionUtils.getDecryptedSymmetricKey(encryptedSymmetricKeyBytes, materials, cryptoProvider);
        CipherFactory cipherFactory = new CipherFactory(symmetricKey, 2, initVectorBytes, cryptoProvider);
        return new EncryptionInstruction(materialsDescription, encryptedSymmetricKeyBytes, symmetricKey, cipherFactory);
    }

    public static PutObjectRequest encryptRequestUsingInstruction(PutObjectRequest request, EncryptionInstruction instruction) {
        long cryptoContentLength;
        ObjectMetadata metadata = request.getObjectMeta();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (metadata.getContentMD5() != null) {
            metadata.setUserMeta(HttpHeaders.UNENCRYPTED_CONTENT_MD5.toString(), metadata.getContentMD5());
        }
        metadata.setContentMD5(null);
        long plaintextLength = EncryptionUtils.getUnencryptedContentLength(request, metadata);
        if (plaintextLength >= 0L) {
            metadata.setUserMeta(HttpHeaders.UNENCRYPTED_CONTENT_LENGTH.toString(), Long.toString(plaintextLength));
        }
        if ((cryptoContentLength = EncryptionUtils.calculateCryptoContentLength(instruction.getSymmetricCipher(), request, metadata)) >= 0L) {
            metadata.setContentLength(cryptoContentLength);
        }
        request.setObjectMeta(metadata);
        request.setInputStream(EncryptionUtils.getEncryptedInputStream(request, instruction.getCipherFactory(), plaintextLength));
        request.setFile(null);
        return request;
    }

    public static Ks3Object decryptObjectUsingInstruction(Ks3Object object, EncryptionInstruction instruction) {
        AutoAbortInputStream objectContent = object.getObjectContent();
        RepeatableCipherInputStream decryptedInputStream = new RepeatableCipherInputStream(objectContent, instruction.getCipherFactory());
        object.setObjectContent(new AutoAbortInputStream(decryptedInputStream, objectContent.getRequest()));
        return object;
    }

    public static PutObjectRequest createInstructionPutRequest(PutObjectRequest request, EncryptionInstruction instruction) {
        JSONObject instructionJSON = EncryptionUtils.convertInstructionToJSONObject(instruction);
        byte[] instructionBytes = instructionJSON.toString().getBytes();
        ByteArrayInputStream instructionInputStream = new ByteArrayInputStream(instructionBytes);
        ObjectMetadata metadata = request.getObjectMeta();
        metadata.setContentLength(instructionBytes.length);
        metadata.setContentMD5(null);
        metadata.setUserMeta(HttpHeaders.CRYPTO_INSTRUCTION_FILE.toString(), request.getKey() + INSTRUCTION_SUFFIX);
        request.setKey(request.getKey() + INSTRUCTION_SUFFIX);
        request.setObjectMeta(metadata);
        request.setInputStream(instructionInputStream);
        return request;
    }

    public static PutObjectRequest createInstructionPutRequest(String bucketName, String key, EncryptionInstruction instruction) {
        JSONObject instructionJSON = EncryptionUtils.convertInstructionToJSONObject(instruction);
        byte[] instructionBytes = instructionJSON.toString().getBytes();
        ByteArrayInputStream instructionInputStream = new ByteArrayInputStream(instructionBytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(instructionBytes.length);
        metadata.setUserMeta(HttpHeaders.CRYPTO_INSTRUCTION_FILE.toString(), key + INSTRUCTION_SUFFIX);
        return new PutObjectRequest(bucketName, key + INSTRUCTION_SUFFIX, instructionInputStream, metadata);
    }

    public static GetObjectRequest createInstructionGetRequest(GetObjectRequest request) {
        return new GetObjectRequest(request.getBucket(), request.getKey() + INSTRUCTION_SUFFIX);
    }

    public static DeleteObjectRequest createInstructionDeleteObjectRequest(DeleteObjectRequest request) {
        return new DeleteObjectRequest(request.getBucket(), request.getKey() + INSTRUCTION_SUFFIX);
    }

    public static boolean isEncryptionInfoInMetadata(Ks3Object retrievedObject) {
        if (retrievedObject.getObjectMetadata() == null) {
            retrievedObject.setObjectMetadata(new ObjectMetadata());
        }
        String iv = retrievedObject.getObjectMetadata().getUserMeta(HttpHeaders.CRYPTO_IV.toString());
        String key = retrievedObject.getObjectMetadata().getUserMeta(HttpHeaders.CRYPTO_KEY.toString());
        return !StringUtils.isBlank(iv) && !StringUtils.isBlank(key);
    }

    public static boolean isEncryptionInfoInInstructionFile(Ks3Object instructionFile) {
        if (instructionFile == null) {
            return false;
        }
        ObjectMetadata metadata = instructionFile.getObjectMetadata();
        if (metadata == null) {
            return false;
        }
        return metadata.containsUserMeta(HttpHeaders.CRYPTO_INSTRUCTION_FILE.toString());
    }

    public static long[] getAdjustedCryptoRange(long[] range) {
        if (range == null || range[0] > range[1]) {
            return null;
        }
        long[] adjustedCryptoRange = new long[]{EncryptionUtils.getCipherBlockLowerBound(range[0]), EncryptionUtils.getCipherBlockUpperBound(range[1])};
        return adjustedCryptoRange;
    }

    public static Ks3Object adjustOutputToDesiredRange(Ks3Object object, long[] range) {
        if (range == null || range[0] > range[1]) {
            return object;
        }
        try {
            AutoAbortInputStream objectContent = object.getObjectContent();
            AdjustedRangeInputStream adjustedRangeContents = new AdjustedRangeInputStream(objectContent, range[0], range[1]);
            object.setObjectContent(new AutoAbortInputStream(adjustedRangeContents, objectContent.getRequest()));
            return object;
        }
        catch (IOException e) {
            throw new Ks3ClientException("Error adjusting output to desired byte range: " + e.getMessage());
        }
    }

    public static SecretKey generateOneTimeUseSymmetricKey() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(JceEncryptionConstants.SYMMETRIC_KEY_ALGORITHM);
            generator.init(JceEncryptionConstants.SYMMETRIC_KEY_LENGTH, new SecureRandom());
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Ks3ClientException("Unable to generate envelope symmetric key:" + e.getMessage(), e);
        }
    }

    public static Cipher createSymmetricCipher(SecretKey symmetricCryptoKey, int encryptMode, Provider cryptoProvider, byte[] initVector) {
        try {
            Cipher cipher = cryptoProvider != null ? Cipher.getInstance(JceEncryptionConstants.SYMMETRIC_CIPHER_METHOD, cryptoProvider) : Cipher.getInstance(JceEncryptionConstants.SYMMETRIC_CIPHER_METHOD);
            if (initVector != null) {
                cipher.init(encryptMode, (Key)symmetricCryptoKey, new IvParameterSpec(initVector));
            } else {
                cipher.init(encryptMode, symmetricCryptoKey);
            }
            return cipher;
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to build cipher: " + e.getMessage() + "\nMake sure you have the JCE unlimited strength policy files installed and " + "configured for your JVM: http://www.ngs.ac.uk/tools/jcepolicyfiles", e);
        }
    }

    public static byte[] getEncryptedSymmetricKey(SecretKey toBeEncrypted, EncryptionMaterials materials, Provider cryptoProvider) {
        Key keyToDoEncryption = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        try {
            byte[] toBeEncryptedBytes = toBeEncrypted.getEncoded();
            Cipher cipher = cryptoProvider != null ? Cipher.getInstance(keyToDoEncryption.getAlgorithm(), cryptoProvider) : Cipher.getInstance(keyToDoEncryption.getAlgorithm());
            cipher.init(1, keyToDoEncryption);
            return cipher.doFinal(toBeEncryptedBytes);
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to encrypt symmetric key: " + e.getMessage(), e);
        }
    }

    private static SecretKey getDecryptedSymmetricKey(byte[] encryptedSymmetricKeyBytes, EncryptionMaterials materials, Provider cryptoProvider) {
        Key keyToDoDecryption = materials.getKeyPair() != null ? materials.getKeyPair().getPrivate() : materials.getSymmetricKey();
        try {
            Cipher cipher = cryptoProvider != null ? Cipher.getInstance(keyToDoDecryption.getAlgorithm(), cryptoProvider) : Cipher.getInstance(keyToDoDecryption.getAlgorithm());
            cipher.init(2, keyToDoDecryption);
            byte[] decryptedSymmetricKeyBytes = cipher.doFinal(encryptedSymmetricKeyBytes);
            return new SecretKeySpec(decryptedSymmetricKeyBytes, JceEncryptionConstants.SYMMETRIC_KEY_ALGORITHM);
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to decrypt symmetric key from object metadata : " + e.getMessage(), e);
        }
    }

    private static InputStream getEncryptedInputStream(PutObjectRequest request, CipherFactory cipherFactory, long plaintextLength) {
        try {
            InputStream is = request.getInputStream();
            if (request.getFile() != null) {
                is = new RepeatableFileInputStream(request.getFile());
            }
            if (plaintextLength > -1L) {
                is = new LengthCheckInputStream(is, plaintextLength, false);
            }
            return new RepeatableCipherInputStream(is, cipherFactory);
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to create cipher input stream: " + e.getMessage(), e);
        }
    }

    public static ByteRangeCapturingInputStream getEncryptedInputStream(UploadPartRequest request, CipherFactory cipherFactory) {
        try {
            InputStream originalInputStream = request.getInputStream();
            if (request.getFile() != null) {
                originalInputStream = new InputSubStream(new RepeatableFileInputStream(request.getFile()), request.getFileoffset(), request.getInstancePartSize(), request.isLastPart());
            }
            originalInputStream = new RepeatableCipherInputStream(originalInputStream, cipherFactory);
            if (!request.isLastPart()) {
                originalInputStream = new InputSubStream(originalInputStream, 0L, request.getInstancePartSize(), false);
            }
            long partSize = request.getInstancePartSize();
            int cipherBlockSize = cipherFactory.createCipher().getBlockSize();
            return new ByteRangeCapturingInputStream(originalInputStream, partSize - (long)cipherBlockSize, partSize);
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to create cipher input stream: " + e.getMessage(), e);
        }
    }

    private static byte[] getCryptoBytesFromMetadata(String headerName, ObjectMetadata metadata) throws NullPointerException {
        if (metadata == null || !metadata.containsUserMeta(headerName)) {
            return null;
        }
        return Base64.decode(metadata.getUserMeta(headerName));
    }

    private static String getStringFromMetadata(String headerName, ObjectMetadata metadata) throws NullPointerException {
        if (metadata == null || !metadata.containsUserMeta(headerName)) {
            return null;
        }
        return metadata.getUserMeta(headerName);
    }

    private static Map<String, String> convertJSONToMap(String descriptionJSONString) {
        if (descriptionJSONString == null) {
            return null;
        }
        JSONObject descriptionJSON = new JSONObject(descriptionJSONString);
        Iterator<String> keysIterator = descriptionJSON.keys();
        HashMap<String, String> materialsDescription = new HashMap<String, String>();
        while (keysIterator.hasNext()) {
            String key = keysIterator.next();
            materialsDescription.put(key, descriptionJSON.getString(key));
        }
        return materialsDescription;
    }

    public static void updateMetadataWithEncryptionInstruction(PutObjectRequest request, EncryptionInstruction instruction) {
        byte[] keyBytesToStoreInMetadata = instruction.getEncryptedSymmetricKey();
        Cipher symmetricCipher = instruction.getSymmetricCipher();
        Map<String, String> materialsDescription = instruction.getMaterialsDescription();
        ObjectMetadata metadata = request.getObjectMeta();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (request.getFile() != null) {
            Mimetypes mimetypes = Mimetypes.getInstance();
            metadata.setContentType(mimetypes.getMimetype(request.getFile()));
        }
        EncryptionUtils.updateMetadata(metadata, keyBytesToStoreInMetadata, symmetricCipher, materialsDescription);
        request.setObjectMeta(metadata);
    }

    private static void updateMetadata(ObjectMetadata metadata, byte[] keyBytesToStoreInMetadata, Cipher symmetricCipher, Map<String, String> materialsDescription) {
        if (keyBytesToStoreInMetadata != null) {
            metadata.setUserMeta(HttpHeaders.CRYPTO_KEY.toString(), Base64.encodeAsString(keyBytesToStoreInMetadata));
        }
        metadata.setUserMeta(HttpHeaders.CRYPTO_IV.toString(), Base64.encodeAsString(symmetricCipher.getIV()));
        JSONObject descriptionJSON = new JSONObject(materialsDescription);
        metadata.setUserMeta(HttpHeaders.MATERIALS_DESCRIPTION.toString(), descriptionJSON.toString());
    }

    public static ObjectMetadata updateMetadataWithEncryptionInfo(InitiateMultipartUploadRequest request, byte[] keyBytesToStoreInMetadata, Cipher symmetricCipher, Map<String, String> materialsDescription) {
        ObjectMetadata metadata = request.getObjectMeta();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        EncryptionUtils.updateMetadata(metadata, keyBytesToStoreInMetadata, symmetricCipher, materialsDescription);
        return metadata;
    }

    private static EncryptionMaterials retrieveOriginalMaterials(Map<String, String> materialsDescription, EncryptionMaterialsAccessor accessor) {
        if (accessor == null) {
            return null;
        }
        return accessor.getEncryptionMaterials(materialsDescription);
    }

    private static long calculateCryptoContentLength(Cipher symmetricCipher, PutObjectRequest request, ObjectMetadata metadata) {
        long plaintextLength = EncryptionUtils.getUnencryptedContentLength(request, metadata);
        if (plaintextLength < 0L) {
            return -1L;
        }
        long cipherBlockSize = symmetricCipher.getBlockSize();
        long offset = cipherBlockSize - plaintextLength % cipherBlockSize;
        return plaintextLength + offset;
    }

    public static long calculateCryptoContentLength(Cipher symmetricCipher, UploadPartRequest request) {
        long plaintextLength;
        if (request.getFile() != null) {
            plaintextLength = request.getInstancePartSize() > 0L ? request.getInstancePartSize() : request.getFile().length();
        } else if (request.getInputStream() != null) {
            plaintextLength = request.getInstancePartSize();
        } else {
            return -1L;
        }
        long cipherBlockSize = symmetricCipher.getBlockSize();
        long offset = cipherBlockSize - plaintextLength % cipherBlockSize;
        return plaintextLength + offset;
    }

    private static long getUnencryptedContentLength(PutObjectRequest request, ObjectMetadata metadata) {
        long fileLength = -1L;
        long lengthInMeta = request.getObjectMeta().getContentLength();
        if (request.getFile() != null) {
            fileLength = request.getFile().length();
        }
        if (fileLength >= 0L) {
            return fileLength;
        }
        if (lengthInMeta > 0L && request.getInputStream() != null) {
            return lengthInMeta;
        }
        return -1L;
    }

    private static JSONObject convertInstructionToJSONObject(EncryptionInstruction instruction) {
        JSONObject instructionJSON = new JSONObject();
        instructionJSON.put(HttpHeaders.MATERIALS_DESCRIPTION.toString(), Jackson.toJsonString(instruction.getMaterialsDescription()));
        instructionJSON.put(HttpHeaders.CRYPTO_KEY.toString(), Base64.encodeAsString(instruction.getEncryptedSymmetricKey()));
        byte[] iv = instruction.getSymmetricCipher().getIV();
        instructionJSON.put(HttpHeaders.CRYPTO_IV.toString(), Base64.encodeAsString(iv));
        return instructionJSON;
    }

    private static JSONObject parseJSONInstruction(Ks3Object instructionObject) {
        try {
            String instructionString = EncryptionUtils.convertStreamToString(instructionObject.getObjectContent());
            return new JSONObject(instructionString);
        }
        catch (Exception e) {
            throw new Ks3ClientException("Error parsing JSON instruction file: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    private static long getCipherBlockLowerBound(long leftmostBytePosition) {
        long cipherBlockSize = JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE;
        long offset = leftmostBytePosition % cipherBlockSize;
        long lowerBound = leftmostBytePosition - offset - cipherBlockSize;
        if (lowerBound < 0L) {
            return 0L;
        }
        return lowerBound;
    }

    private static long getCipherBlockUpperBound(long rightmostBytePosition) {
        long cipherBlockSize = JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE;
        long offset = cipherBlockSize - rightmostBytePosition % cipherBlockSize;
        return rightmostBytePosition + offset + cipherBlockSize;
    }
}

