/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.encryption.internal;

import com.ksyun.ks3.dto.Ks3Object;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.service.encryption.internal.CipherLite;
import com.ksyun.ks3.service.encryption.internal.ContentCryptoScheme;
import com.ksyun.ks3.service.encryption.internal.JceEncryptionConstants;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterials;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterialsAccessor;
import com.ksyun.ks3.utils.Base64;
import com.ksyun.ks3.utils.Jackson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;

    ContentCryptoMaterial(Map<String, String> kekMaterialsDescription, byte[] encryptedCEK, String keyWrappingAlgorithm, CipherLite cipherLite) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
        this.encryptedCEK = (byte[])encryptedCEK.clone();
        this.kekMaterialsDescription = kekMaterialsDescription;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata metadata) {
        String keyWrapAlgo;
        byte[] encryptedCEK = this.getEncryptedCEK();
        metadata.setUserMeta(HttpHeaders.CRYPTO_KEY_V2.toString(), Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        metadata.setUserMeta(HttpHeaders.CRYPTO_IV.toString(), Base64.encodeAsString(iv));
        metadata.setUserMeta(HttpHeaders.MATERIALS_DESCRIPTION.toString(), this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        metadata.setUserMeta(HttpHeaders.CRYPTO_CEK_ALGORITHM.toString(), scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            metadata.setUserMeta(HttpHeaders.CRYPTO_TAG_LENGTH.toString(), String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            metadata.setUserMeta(HttpHeaders.CRYPTO_KEYWRAP_ALGORITHM.toString(), keyWrapAlgo);
        }
        return metadata;
    }

    String toJsonString() {
        String keyWrapAlgo;
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] encryptedCEK = this.getEncryptedCEK();
        map.put(HttpHeaders.CRYPTO_KEY_V2.toString(), Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        map.put(HttpHeaders.CRYPTO_IV.toString(), Base64.encodeAsString(iv));
        map.put(HttpHeaders.MATERIALS_DESCRIPTION.toString(), this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        map.put(HttpHeaders.CRYPTO_CEK_ALGORITHM.toString(), scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            map.put(HttpHeaders.CRYPTO_TAG_LENGTH.toString(), String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            map.put(HttpHeaders.CRYPTO_KEYWRAP_ALGORITHM.toString(), keyWrapAlgo);
        }
        return Jackson.toJsonString(map);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> kekMaterialDesc = this.getKEKMaterialsDescription();
        if (kekMaterialDesc == null) {
            kekMaterialDesc = Collections.emptyMap();
        }
        return Jackson.toJsonString(kekMaterialDesc);
    }

    private static Map<String, String> matdescFromJson(String json) {
        Map map = Jackson.fromJsonString(json, Map.class);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, Provider securityProvider) {
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPrivate() : materials.getSymmetricKey();
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = securityProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, securityProvider);
                cipher.init(4, kek);
                return (SecretKey)cipher.unwrap(cekSecured, keyWrapAlgo, 3);
            }
            Cipher cipher = securityProvider != null ? Cipher.getInstance(kek.getAlgorithm(), securityProvider) : Cipher.getInstance(kek.getAlgorithm());
            cipher.init(2, kek);
            byte[] decryptedSymmetricKeyBytes = cipher.doFinal(cekSecured);
            return new SecretKeySpec(decryptedSymmetricKeyBytes, JceEncryptionConstants.SYMMETRIC_KEY_ALGORITHM);
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to decrypt symmetric key from object metadata : " + e.getMessage(), e);
        }
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range) {
        EncryptionMaterials materials;
        String b64key = metadata.getUserMeta(HttpHeaders.CRYPTO_KEY_V2.toString());
        if (b64key == null && (b64key = metadata.getUserMeta(HttpHeaders.CRYPTO_KEY.toString())) == null) {
            throw new Ks3ClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv = Base64.decode(metadata.getUserMeta(HttpHeaders.CRYPTO_IV.toString()));
        if (cekWrapped == null || iv == null) {
            throw new Ks3ClientException("Content encrypting key or IV not found.");
        }
        String matdescStr = metadata.getUserMeta(HttpHeaders.MATERIALS_DESCRIPTION.toString());
        Map<String, String> matdesc = ContentCryptoMaterial.matdescFromJson(matdescStr);
        EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(matdesc);
        if (materials == null) {
            throw new Ks3ClientException("Unable to retrieve the client encryption materials");
        }
        String cekAlgo = metadata.getUserMeta(HttpHeaders.CRYPTO_CEK_ALGORITHM.toString());
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = metadata.getUserMeta(HttpHeaders.CRYPTO_TAG_LENGTH.toString())))) {
                throw new Ks3ClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        String keyWrapAlgo = metadata.getUserMeta(HttpHeaders.CRYPTO_KEYWRAP_ALGORITHM.toString());
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider);
        return new ContentCryptoMaterial(matdesc, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider));
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range) {
        return ContentCryptoMaterial.fromInstructionFile0(instFile, kekMaterialAccessor, securityProvider, range);
    }

    private static ContentCryptoMaterial fromInstructionFile0(Map<String, String> map, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range) {
        EncryptionMaterials materials;
        String b64key = map.get(HttpHeaders.CRYPTO_KEY_V2.toString());
        if (b64key == null && (b64key = map.get(HttpHeaders.CRYPTO_KEY.toString())) == null) {
            throw new Ks3ClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv = Base64.decode(map.get(HttpHeaders.CRYPTO_IV.toString()));
        if (cekWrapped == null || iv == null) {
            throw new Ks3ClientException("Necessary encryption info not found in the instruction file " + map);
        }
        String matdescStr = map.get(HttpHeaders.MATERIALS_DESCRIPTION.toString());
        Map<String, String> matdesc = ContentCryptoMaterial.matdescFromJson(matdescStr);
        EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(matdesc);
        if (materials == null) {
            throw new Ks3ClientException("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file " + map);
        }
        String cekAlgo = map.get(HttpHeaders.CRYPTO_CEK_ALGORITHM.toString());
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = map.get(HttpHeaders.CRYPTO_TAG_LENGTH.toString())))) {
                throw new Ks3ClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        String keyWrapAlgo = map.get(HttpHeaders.CRYPTO_KEYWRAP_ALGORITHM.toString());
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider);
        return new ContentCryptoMaterial(matdesc, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider));
    }

    static String parseInstructionFile(Ks3Object instructionFile) {
        try {
            return ContentCryptoMaterial.convertStreamToString(instructionFile.getObjectContent());
        }
        catch (Exception e) {
            throw new Ks3ClientException("Error parsing JSON instruction file: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }
}

