/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service;

import com.ksyun.ks3.config.ClientConfig;
import com.ksyun.ks3.config.Constants;
import com.ksyun.ks3.dto.AccessControlList;
import com.ksyun.ks3.dto.AccessControlPolicy;
import com.ksyun.ks3.dto.Adp;
import com.ksyun.ks3.dto.AdpTask;
import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.dto.Bucket;
import com.ksyun.ks3.dto.BucketCorsConfiguration;
import com.ksyun.ks3.dto.BucketLoggingStatus;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.dto.CompleteMultipartUploadResult;
import com.ksyun.ks3.dto.CopyResult;
import com.ksyun.ks3.dto.CreateBucketConfiguration;
import com.ksyun.ks3.dto.DeleteMultipleObjectsResult;
import com.ksyun.ks3.dto.GetObjectResult;
import com.ksyun.ks3.dto.Grant;
import com.ksyun.ks3.dto.GranteeUri;
import com.ksyun.ks3.dto.HeadBucketResult;
import com.ksyun.ks3.dto.HeadObjectResult;
import com.ksyun.ks3.dto.InitiateMultipartUploadResult;
import com.ksyun.ks3.dto.Ks3ObjectSummary;
import com.ksyun.ks3.dto.ListMultipartUploadsResult;
import com.ksyun.ks3.dto.ListPartsResult;
import com.ksyun.ks3.dto.ObjectListing;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.PartETag;
import com.ksyun.ks3.dto.Permission;
import com.ksyun.ks3.dto.PostObjectFormFields;
import com.ksyun.ks3.dto.PostPolicy;
import com.ksyun.ks3.dto.PostPolicyCondition;
import com.ksyun.ks3.dto.PutAdpResult;
import com.ksyun.ks3.dto.PutObjectResult;
import com.ksyun.ks3.dto.ResponseHeaderOverrides;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.Ks3ServiceException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.exception.serviceside.NotFoundException;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Ks3CoreController;
import com.ksyun.ks3.service.Ks3;
import com.ksyun.ks3.service.request.AbortMultipartUploadRequest;
import com.ksyun.ks3.service.request.CompleteMultipartUploadRequest;
import com.ksyun.ks3.service.request.CopyObjectRequest;
import com.ksyun.ks3.service.request.CopyPartRequest;
import com.ksyun.ks3.service.request.CreateBucketRequest;
import com.ksyun.ks3.service.request.DeleteBucketCorsRequest;
import com.ksyun.ks3.service.request.DeleteBucketRequest;
import com.ksyun.ks3.service.request.DeleteMultipleObjectsRequest;
import com.ksyun.ks3.service.request.DeleteObjectRequest;
import com.ksyun.ks3.service.request.GetAdpRequest;
import com.ksyun.ks3.service.request.GetBucketACLRequest;
import com.ksyun.ks3.service.request.GetBucketCorsRequest;
import com.ksyun.ks3.service.request.GetBucketLocationRequest;
import com.ksyun.ks3.service.request.GetBucketLoggingRequest;
import com.ksyun.ks3.service.request.GetObjectACLRequest;
import com.ksyun.ks3.service.request.GetObjectRequest;
import com.ksyun.ks3.service.request.HeadBucketRequest;
import com.ksyun.ks3.service.request.HeadObjectRequest;
import com.ksyun.ks3.service.request.InitiateMultipartUploadRequest;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.request.ListBucketsRequest;
import com.ksyun.ks3.service.request.ListMultipartUploadsRequest;
import com.ksyun.ks3.service.request.ListObjectsRequest;
import com.ksyun.ks3.service.request.ListPartsRequest;
import com.ksyun.ks3.service.request.PutAdpRequest;
import com.ksyun.ks3.service.request.PutBucketACLRequest;
import com.ksyun.ks3.service.request.PutBucketCorsRequest;
import com.ksyun.ks3.service.request.PutBucketLoggingRequest;
import com.ksyun.ks3.service.request.PutObjectACLRequest;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.service.request.UploadPartRequest;
import com.ksyun.ks3.service.response.AbortMultipartUploadResponse;
import com.ksyun.ks3.service.response.CompleteMultipartUploadResponse;
import com.ksyun.ks3.service.response.CopyObjectResponse;
import com.ksyun.ks3.service.response.CopyPartResponse;
import com.ksyun.ks3.service.response.CreateBucketResponse;
import com.ksyun.ks3.service.response.DeleteBucketCorsResponse;
import com.ksyun.ks3.service.response.DeleteBucketResponse;
import com.ksyun.ks3.service.response.DeleteMultipleObjectsResponse;
import com.ksyun.ks3.service.response.DeleteObjectResponse;
import com.ksyun.ks3.service.response.GetAdpResponse;
import com.ksyun.ks3.service.response.GetBucketACLResponse;
import com.ksyun.ks3.service.response.GetBucketCorsResponse;
import com.ksyun.ks3.service.response.GetBucketLocationResponse;
import com.ksyun.ks3.service.response.GetBucketLoggingResponse;
import com.ksyun.ks3.service.response.GetObjectACLResponse;
import com.ksyun.ks3.service.response.GetObjectResponse;
import com.ksyun.ks3.service.response.HeadBucketResponse;
import com.ksyun.ks3.service.response.HeadObjectResponse;
import com.ksyun.ks3.service.response.InitiateMultipartUploadResponse;
import com.ksyun.ks3.service.response.Ks3WebServiceResponse;
import com.ksyun.ks3.service.response.ListBucketsResponse;
import com.ksyun.ks3.service.response.ListMultipartUploadsResponse;
import com.ksyun.ks3.service.response.ListObjectsResponse;
import com.ksyun.ks3.service.response.ListPartsResponse;
import com.ksyun.ks3.service.response.PutAdpResponse;
import com.ksyun.ks3.service.response.PutBucketACLResponse;
import com.ksyun.ks3.service.response.PutBucketCorsResponse;
import com.ksyun.ks3.service.response.PutBucketLoggingResponse;
import com.ksyun.ks3.service.response.PutObjectACLResponse;
import com.ksyun.ks3.service.response.PutObjectResponse;
import com.ksyun.ks3.service.response.UploadPartResponse;
import com.ksyun.ks3.utils.AuthUtils;
import com.ksyun.ks3.utils.DateUtils;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ks3Client
implements Ks3 {
    private static final Log log = LogFactory.getLog(Ks3Client.class);
    private ClientConfig config = ClientConfig.getConfig();
    private Authorization auth;
    private Ks3CoreController client = new Ks3CoreController();

    public Authorization getAuth() {
        return this.auth;
    }

    @Override
    public void setAuth(Authorization auth) {
        this.auth = auth;
    }

    public Ks3Client() {
    }

    public Ks3Client(Authorization auth) {
        this.auth = auth;
    }

    public Ks3Client(String accesskeyid, String accesskeysecret) {
        this.auth = new Authorization(accesskeyid, accesskeysecret);
    }

    @Override
    public List<Bucket> listBuckets() throws Ks3ClientException, Ks3ServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (List)this.client.execute(this.auth, request, ListBucketsResponse.class);
    }

    @Override
    public CreateBucketConfiguration.REGION getBucketLoaction(String bucketName) throws Ks3ClientException, Ks3ServiceException {
        GetBucketLocationRequest request = new GetBucketLocationRequest(bucketName);
        return this.getBucketLoaction(request);
    }

    @Override
    public CreateBucketConfiguration.REGION getBucketLoaction(GetBucketLocationRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (CreateBucketConfiguration.REGION)((Object)this.client.execute(this.auth, request, GetBucketLocationResponse.class));
    }

    @Override
    public BucketLoggingStatus getBucketLogging(String bucketName) throws Ks3ClientException, Ks3ServiceException {
        GetBucketLoggingRequest request = new GetBucketLoggingRequest(bucketName);
        return this.getBucketLogging(request);
    }

    @Override
    public BucketLoggingStatus getBucketLogging(GetBucketLoggingRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (BucketLoggingStatus)this.client.execute(this.auth, request, GetBucketLoggingResponse.class);
    }

    @Override
    public void putBucketLogging(String bucketName, boolean enable, String targetBucket) throws Ks3ClientException, Ks3ServiceException {
        PutBucketLoggingRequest request = new PutBucketLoggingRequest(bucketName, enable, targetBucket);
        this.putBucketLogging(request);
    }

    @Override
    public void putBucketLogging(String bucketName, boolean enable, String targetBucket, String targetPrefix) throws Ks3ClientException, Ks3ServiceException {
        PutBucketLoggingRequest request = new PutBucketLoggingRequest(bucketName, enable, targetBucket, targetPrefix);
        this.putBucketLogging(request);
    }

    @Override
    public void putBucketLogging(PutBucketLoggingRequest request) throws Ks3ClientException, Ks3ServiceException {
        this.client.execute(this.auth, request, PutBucketLoggingResponse.class);
    }

    @Override
    public AccessControlPolicy getBucketACL(String bucketName) throws Ks3ClientException, Ks3ServiceException {
        return this.getBucketACL(new GetBucketACLRequest(bucketName));
    }

    @Override
    public CannedAccessControlList getBucketCannedACL(String bucketName) throws Ks3ClientException, Ks3ServiceException {
        return this.getBucketACL(bucketName).getCannedAccessControlList();
    }

    @Override
    public CannedAccessControlList getBucketCannedACL(GetBucketACLRequest request) throws Ks3ClientException, Ks3ServiceException {
        return this.getBucketACL(request).getCannedAccessControlList();
    }

    @Override
    public AccessControlPolicy getBucketACL(GetBucketACLRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (AccessControlPolicy)this.client.execute(this.auth, request, GetBucketACLResponse.class);
    }

    @Override
    public void putBucketACL(String bucketName, AccessControlList accessControlList) throws Ks3ClientException, Ks3ServiceException {
        this.putBucketACL(new PutBucketACLRequest(bucketName, accessControlList));
    }

    @Override
    public void putBucketACL(PutBucketACLRequest request) throws Ks3ClientException, Ks3ServiceException {
        this.client.execute(this.auth, request, PutBucketACLResponse.class);
    }

    @Override
    public void putObjectACL(String bucketName, String objectName, AccessControlList accessControlList) throws Ks3ClientException, Ks3ServiceException {
        this.putObjectACL(new PutObjectACLRequest(bucketName, objectName, accessControlList));
    }

    @Override
    public void putObjectACL(PutObjectACLRequest request) throws Ks3ClientException, Ks3ServiceException {
        this.client.execute(this.auth, request, PutObjectACLResponse.class);
    }

    @Override
    public AccessControlPolicy getObjectACL(String bucketName, String objectName) throws Ks3ClientException, Ks3ServiceException {
        return this.getObjectACL(new GetObjectACLRequest(bucketName, objectName));
    }

    @Override
    public CannedAccessControlList getObjectCannedACL(String bucketName, String ObjectName) throws Ks3ClientException, Ks3ServiceException {
        return this.getObjectACL(bucketName, ObjectName).getCannedAccessControlList();
    }

    @Override
    public CannedAccessControlList getObjectCannedACL(GetObjectACLRequest request) throws Ks3ClientException, Ks3ServiceException {
        return this.getObjectACL(request).getCannedAccessControlList();
    }

    @Override
    public AccessControlPolicy getObjectACL(GetObjectACLRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (AccessControlPolicy)this.client.execute(this.auth, request, GetObjectACLResponse.class);
    }

    @Override
    public Bucket createBucket(String bucketname) throws Ks3ClientException, Ks3ServiceException {
        return this.createBucket(new CreateBucketRequest(bucketname));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest request) throws Ks3ClientException, Ks3ServiceException {
        Bucket bucket = (Bucket)this.client.execute(this.auth, request, CreateBucketResponse.class);
        bucket.setName(request.getBucket());
        return bucket;
    }

    @Override
    public void clearBucket(String bucketName) throws Ks3ClientException, Ks3ServiceException {
        this.removeDir(bucketName, null);
    }

    @Override
    public void makeDir(String bucketName, String dir) throws Ks3ClientException, Ks3ServiceException {
        if (!dir.endsWith("/")) {
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("dir", dir, "ends with /");
        }
        PutObjectRequest request = new PutObjectRequest(bucketName, dir, new ByteArrayInputStream(new byte[0]), null);
        this.putObject(request);
    }

    @Override
    public void removeDir(String bucketName, String dir) throws Ks3ClientException, Ks3ServiceException {
        if (dir != null && !dir.endsWith("/") && !StringUtils.isBlank(dir)) {
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("dir", dir, "ends with / or blank");
        }
        String marker = null;
        ObjectListing list = null;
        do {
            ListObjectsRequest request = new ListObjectsRequest(bucketName);
            request.setPrefix(dir);
            request.setMarker(marker);
            list = this.listObjects(request);
            ArrayList<String> keys = new ArrayList<String>();
            for (Ks3ObjectSummary obj : list.getObjectSummaries()) {
                keys.add(obj.getKey());
                marker = obj.getKey();
            }
            if (keys.size() <= 0) break;
            this.deleteObjects(keys, bucketName);
        } while (list.isTruncated());
        if (dir != null) {
            boolean exists = true;
            try {
                this.headObject(bucketName, dir);
            }
            catch (NotFoundException e) {
                exists = false;
            }
            if (exists) {
                this.deleteObject(bucketName, dir);
            }
        }
    }

    @Override
    public void deleteBucket(String bucketname) throws Ks3ClientException, Ks3ServiceException {
        this.deleteBucket(new DeleteBucketRequest(bucketname));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest request) throws Ks3ClientException, Ks3ServiceException {
        this.client.execute(this.auth, request, DeleteBucketResponse.class);
    }

    @Override
    public ObjectListing listObjects(String bucketname) throws Ks3ClientException, Ks3ServiceException {
        return this.listObjects(new ListObjectsRequest(bucketname, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String bucketname, String prefix) throws Ks3ClientException, Ks3ServiceException {
        return this.listObjects(new ListObjectsRequest(bucketname, prefix, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (ObjectListing)this.client.execute(this.auth, request, ListObjectsResponse.class);
    }

    @Override
    public void deleteObject(String bucketname, String key) throws Ks3ClientException, Ks3ServiceException {
        this.deleteObject(new DeleteObjectRequest(bucketname, key));
    }

    @Override
    public void deleteObject(DeleteObjectRequest request) throws Ks3ClientException, Ks3ServiceException {
        this.client.execute(this.auth, request, DeleteObjectResponse.class);
    }

    @Override
    public GetObjectResult getObject(String bucketname, String key) throws Ks3ClientException, Ks3ServiceException {
        return this.getObject(new GetObjectRequest(bucketname, key));
    }

    @Override
    public GetObjectResult getObject(GetObjectRequest request) throws Ks3ClientException, Ks3ServiceException {
        String objectkey = request.getKey();
        GetObjectResult object = (GetObjectResult)this.client.execute(this.auth, request, GetObjectResponse.class);
        object.getObject().setBucketName(request.getBucket());
        object.getObject().setKey(objectkey);
        return object;
    }

    @Override
    public String generatePresignedUrl(String bucket, String key, int expiration) throws Ks3ClientException {
        return this.generatePresignedUrl(bucket, key, expiration, null);
    }

    @Override
    public String generatePresignedUrl(String bucket, String key, int expiration, ResponseHeaderOverrides overrides) throws Ks3ClientException {
        if (overrides == null) {
            overrides = new ResponseHeaderOverrides();
        }
        boolean isPrivate = false;
        AccessControlList acl = this.getObjectACL(bucket, key).getAccessControlList();
        LinkedHashSet<Permission> allUsersPermissions = new LinkedHashSet<Permission>();
        for (Grant grant : acl.getGrants()) {
            if (!GranteeUri.AllUsers.equals(grant.getGrantee())) continue;
            allUsersPermissions.add(grant.getPermission());
        }
        boolean read = allUsersPermissions.contains((Object)Permission.Read);
        boolean write = allUsersPermissions.contains((Object)Permission.Write);
        isPrivate = read && write ? false : !read;
        key = HttpUtils.urlEncode(key, true);
        if (isPrivate) {
            String signature = "";
            long expires = System.currentTimeMillis() / 1000L + (long)expiration;
            try {
                signature = AuthUtils.calcSignature(this.auth.getAccessKeySecret(), bucket, key, overrides.getOverrides(), HttpMethod.GET.toString(), expires);
            }
            catch (SignatureException e) {
                e.printStackTrace();
                throw new Ks3ClientException("\u8ba1\u7b97\u7528\u6237\u7b7e\u540d\u65f6\u51fa\u9519", e);
            }
            if (overrides.getOverrides().size() > 0) {
                return "http://" + bucket + "." + this.config.getStr("ks3client.cdn.endpoint") + "/" + key + "?AccessKeyId=" + URLEncoder.encode(this.auth.getAccessKeyId()) + "&Expires=" + expires + "&Signature=" + URLEncoder.encode(signature) + "&" + HttpUtils.encodeParams(overrides.getOverrides());
            }
            return "http://" + bucket + "." + this.config.getStr("ks3client.cdn.endpoint") + "/" + key + "?AccessKeyId=" + URLEncoder.encode(this.auth.getAccessKeyId()) + "&Expires=" + expires + "&Signature=" + URLEncoder.encode(signature);
        }
        return "http://" + bucket + "." + this.config.getStr("ks3client.cdn.endpoint") + "/" + key + "?" + HttpUtils.encodeParams(overrides.getOverrides());
    }

    @Override
    public HeadBucketResult headBucket(String bucketname) throws Ks3ClientException, Ks3ServiceException {
        return this.headBucket(new HeadBucketRequest(bucketname));
    }

    @Override
    public HeadBucketResult headBucket(HeadBucketRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (HeadBucketResult)this.client.execute(this.auth, request, HeadBucketResponse.class);
    }

    @Override
    public boolean bucketExists(String bucketname) throws Ks3ClientException, Ks3ServiceException {
        try {
            HeadBucketResult result = this.headBucket(bucketname);
            if (result.getStatueCode() == 404) {
                return false;
            }
            return result.getStatueCode() == 200 || result.getStatueCode() == 301 || result.getStatueCode() == 403;
        }
        catch (Ks3ClientException e) {
            return false;
        }
    }

    @Override
    public PutObjectResult putObject(String bucketname, String objectkey, File file) throws Ks3ClientException, Ks3ServiceException {
        return this.putObject(new PutObjectRequest(bucketname, objectkey, file));
    }

    @Override
    public PutObjectResult putObject(String bucketname, String objectkey, InputStream inputstream, ObjectMetadata objectmeta) throws Ks3ClientException, Ks3ServiceException {
        return this.putObject(new PutObjectRequest(bucketname, objectkey, inputstream, objectmeta));
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) throws Ks3ClientException, Ks3ServiceException {
        PutObjectResult obj = (PutObjectResult)this.client.execute(this.auth, request, PutObjectResponse.class);
        return obj;
    }

    @Override
    public CopyResult copyObject(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey) throws Ks3ClientException, Ks3ServiceException {
        CopyObjectRequest request = new CopyObjectRequest(destinationBucket, destinationObject, sourceBucket, sourceKey);
        return this.copyObject(request);
    }

    @Override
    public CopyResult copyObject(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, CannedAccessControlList cannedAcl) throws Ks3ClientException, Ks3ServiceException {
        CopyObjectRequest request = new CopyObjectRequest(destinationBucket, destinationObject, sourceBucket, sourceKey, cannedAcl);
        return this.copyObject(request);
    }

    @Override
    public CopyResult copyObject(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, AccessControlList accessControlList) throws Ks3ClientException, Ks3ServiceException {
        CopyObjectRequest request = new CopyObjectRequest(destinationBucket, destinationObject, sourceBucket, sourceKey, accessControlList);
        return this.copyObject(request);
    }

    @Override
    public CopyResult copyObject(CopyObjectRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (CopyResult)this.client.execute(this.auth, request, CopyObjectResponse.class);
    }

    @Override
    public HeadObjectResult headObject(String bucketname, String objectkey) throws Ks3ClientException, Ks3ServiceException {
        return this.headObject(new HeadObjectRequest(bucketname, objectkey));
    }

    @Override
    public HeadObjectResult headObject(HeadObjectRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (HeadObjectResult)this.client.execute(this.auth, request, HeadObjectResponse.class);
    }

    @Override
    public boolean objectExists(String bucket, String key) {
        try {
            this.headObject(bucket, key);
        }
        catch (NotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(String bucketname, String objectkey) throws Ks3ClientException, Ks3ServiceException {
        return this.initiateMultipartUpload(new InitiateMultipartUploadRequest(bucketname, objectkey));
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws Ks3ClientException, Ks3ServiceException {
        String objectkey = request.getKey();
        InitiateMultipartUploadResult result = (InitiateMultipartUploadResult)this.client.execute(this.auth, request, InitiateMultipartUploadResponse.class);
        result.setBucket(request.getBucket());
        result.setKey(objectkey);
        return result;
    }

    @Override
    public PartETag uploadPart(UploadPartRequest request) throws Ks3ClientException, Ks3ServiceException {
        PartETag result = (PartETag)this.client.execute(this.auth, request, UploadPartResponse.class);
        result.setPartNumber(request.getPartNumber());
        return result;
    }

    @Override
    public CopyResult copyPart(CopyPartRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (CopyResult)this.client.execute(this.auth, request, CopyPartResponse.class);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(String bucketname, String objectkey, String uploadId, List<PartETag> partETags) throws Ks3ClientException, Ks3ServiceException {
        return this.completeMultipartUpload(new CompleteMultipartUploadRequest(bucketname, objectkey, uploadId, partETags));
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(ListPartsResult result) throws Ks3ClientException, Ks3ServiceException {
        return this.completeMultipartUpload(new CompleteMultipartUploadRequest(result));
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (CompleteMultipartUploadResult)this.client.execute(this.auth, request, CompleteMultipartUploadResponse.class);
    }

    @Override
    public void abortMultipartUpload(String bucketname, String objectkey, String uploadId) throws Ks3ClientException, Ks3ServiceException {
        this.abortMultipartUpload(new AbortMultipartUploadRequest(bucketname, objectkey, uploadId));
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest request) throws Ks3ClientException, Ks3ServiceException {
        this.client.execute(this.auth, request, AbortMultipartUploadResponse.class);
    }

    @Override
    public ListPartsResult listParts(String bucketname, String objectkey, String uploadId) throws Ks3ClientException, Ks3ServiceException {
        ListPartsRequest request = new ListPartsRequest(bucketname, objectkey, uploadId);
        return this.listParts(request);
    }

    @Override
    public ListPartsResult listParts(String bucketname, String objectkey, String uploadId, int maxParts) throws Ks3ClientException, Ks3ServiceException {
        ListPartsRequest request = new ListPartsRequest(bucketname, objectkey, uploadId);
        request.setMaxParts(maxParts);
        return this.listParts(request);
    }

    @Override
    public ListPartsResult listParts(String bucketname, String objectkey, String uploadId, int maxParts, int partNumberMarker) throws Ks3ClientException, Ks3ServiceException {
        ListPartsRequest request = new ListPartsRequest(bucketname, objectkey, uploadId);
        request.setMaxParts(maxParts);
        request.setPartNumberMarker(partNumberMarker);
        return this.listParts(request);
    }

    @Override
    public ListPartsResult listParts(ListPartsRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (ListPartsResult)this.client.execute(this.auth, request, ListPartsResponse.class);
    }

    @Override
    public void putObjectACL(String bucketName, String objectName, CannedAccessControlList accessControlList) throws Ks3ClientException, Ks3ServiceException {
        this.putObjectACL(new PutObjectACLRequest(bucketName, objectName, accessControlList));
    }

    @Override
    public void putBucketACL(String bucketName, CannedAccessControlList CannedAcl) throws Ks3ClientException, Ks3ServiceException {
        this.putBucketACL(new PutBucketACLRequest(bucketName, CannedAcl));
    }

    @Override
    public DeleteMultipleObjectsResult deleteObjects(DeleteMultipleObjectsRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (DeleteMultipleObjectsResult)this.client.execute(this.auth, request, DeleteMultipleObjectsResponse.class);
    }

    @Override
    public DeleteMultipleObjectsResult deleteObjects(List<String> keys, String bucketName) throws Ks3ClientException, Ks3ServiceException {
        return this.deleteObjects(new DeleteMultipleObjectsRequest(bucketName, keys));
    }

    @Override
    public DeleteMultipleObjectsResult deleteObjects(String[] keys, String bucketName) throws Ks3ClientException, Ks3ServiceException {
        return this.deleteObjects(new DeleteMultipleObjectsRequest(bucketName, keys));
    }

    @Override
    public ListMultipartUploadsResult listMultipartUploads(String bucketName) throws Ks3ClientException, Ks3ServiceException {
        ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(bucketName);
        return this.listMultipartUploads(request);
    }

    @Override
    public ListMultipartUploadsResult listMultipartUploads(String bucketName, String prefix) throws Ks3ClientException, Ks3ServiceException {
        ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(bucketName, prefix);
        return this.listMultipartUploads(request);
    }

    @Override
    public ListMultipartUploadsResult listMultipartUploads(String bucketName, String prefix, String keyMarker, String uploadIdMarker) throws Ks3ClientException, Ks3ServiceException {
        ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(bucketName, prefix, keyMarker, uploadIdMarker);
        return this.listMultipartUploads(request);
    }

    @Override
    public ListMultipartUploadsResult listMultipartUploads(ListMultipartUploadsRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (ListMultipartUploadsResult)this.client.execute(this.auth, request, ListMultipartUploadsResponse.class);
    }

    @Override
    public void putBucketCors(PutBucketCorsRequest request) throws Ks3ClientException, Ks3ServiceException {
        this.client.execute(this.auth, request, PutBucketCorsResponse.class);
    }

    @Override
    public BucketCorsConfiguration getBucketCors(String bucketname) throws Ks3ClientException, Ks3ServiceException {
        return this.getBucketCors(new GetBucketCorsRequest(bucketname));
    }

    @Override
    public BucketCorsConfiguration getBucketCors(GetBucketCorsRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (BucketCorsConfiguration)this.client.execute(this.auth, request, GetBucketCorsResponse.class);
    }

    @Override
    public void deleteBucketCors(String bucketname) throws Ks3ClientException, Ks3ServiceException {
        this.deleteBucketCors(new DeleteBucketCorsRequest(bucketname));
    }

    @Override
    public void deleteBucketCors(DeleteBucketCorsRequest request) throws Ks3ClientException, Ks3ServiceException {
        this.client.execute(this.auth, request, DeleteBucketCorsResponse.class);
    }

    @Override
    public <X extends Ks3WebServiceResponse<Y>, Y> Y execute(Ks3WebServiceRequest request, Class<X> clazz) throws Ks3ClientException, Ks3ServiceException {
        return this.client.execute(this.auth, request, clazz);
    }

    @Override
    public PostObjectFormFields postObject(PostPolicy policy) throws Ks3ClientException {
        HashMap<String, Object> policyMap = new HashMap<String, Object>();
        policyMap.put("expiration", policy.getExpiration());
        ArrayList conditions = new ArrayList();
        for (PostPolicyCondition condition : policy.getConditions()) {
            ArrayList<String> conditionList = new ArrayList<String>();
            if (condition.getMatchingType() != PostPolicyCondition.MatchingType.contentLengthRange) {
                if (!condition.getParamA().startsWith("$")) {
                    condition.setParamA("$" + condition.getParamA());
                }
            } else if (!StringUtils.checkLong(condition.getParamA()) || !StringUtils.checkLong(condition.getParamB())) {
                throw new ClientIllegalArgumentException("contentLengthRange\u5339\u914d\u89c4\u5219\u7684\u53c2\u6570A\u548c\u53c2\u6570B\u90fd\u5e94\u8be5\u662fLong\u578b");
            }
            conditionList.add(condition.getMatchingType().toString());
            if (condition.getMatchingType() != PostPolicyCondition.MatchingType.contentLengthRange && !Constants.postFormUnIgnoreCase.contains(condition.getParamA().substring(1))) {
                conditionList.add(condition.getParamA().toLowerCase());
            } else {
                conditionList.add(condition.getParamA());
            }
            conditionList.add(condition.getParamB());
            conditions.add(conditionList);
        }
        policyMap.put("conditions", conditions);
        String policyJson = StringUtils.object2json(policyMap);
        String policyBase64 = "";
        try {
            policyBase64 = new String(Base64.encodeBase64((byte[])policyJson.getBytes()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        PostObjectFormFields fields = new PostObjectFormFields();
        fields.setKssAccessKeyId(this.auth.getAccessKeyId());
        fields.setPolicy(policyBase64);
        try {
            fields.setSignature(AuthUtils.calcSignature(this.auth.getAccessKeySecret(), policyBase64));
        }
        catch (SignatureException e) {
            throw new Ks3ClientException("\u8ba1\u7b97\u7b7e\u540d\u51fa\u9519", e);
        }
        return fields;
    }

    @Override
    public PostObjectFormFields postObject(String bucket, String filename, Map<String, String> postFormData, List<String> unknowValueFormFiled) throws Ks3ClientException {
        PostPolicyCondition condition;
        if (StringUtils.isBlank(bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucket");
        }
        if (postFormData == null) {
            postFormData = new HashMap<String, String>();
        }
        if (unknowValueFormFiled == null) {
            unknowValueFormFiled = new ArrayList<String>();
        }
        postFormData.put("bucket", bucket);
        PostPolicy policy = new PostPolicy();
        policy.setExpiration(DateUtils.convertDate2Str(new DateTime().plusHours(5).toDate(), DateUtils.DATETIME_PROTOCOL.ISO8861));
        for (Map.Entry<String, String> entry : postFormData.entrySet()) {
            if (Constants.postFormIgnoreFields.contains(entry.getKey())) continue;
            condition = new PostPolicyCondition();
            condition.setMatchingType(PostPolicyCondition.MatchingType.eq);
            condition.setParamA("$" + entry.getKey());
            condition.setParamB(entry.getValue().replace("${filename}", filename));
            policy.getConditions().add(condition);
        }
        for (String field : unknowValueFormFiled) {
            if (Constants.postFormIgnoreFields.contains(field)) continue;
            condition = new PostPolicyCondition();
            condition.setMatchingType(PostPolicyCondition.MatchingType.startsWith);
            condition.setParamA("$" + field);
            condition.setParamB("");
            policy.getConditions().add(condition);
        }
        return this.postObject(policy);
    }

    @Override
    public PutAdpResult putAdpTask(String bucketName, String objectKey, List<Adp> adps) throws Ks3ClientException, Ks3ServiceException {
        PutAdpRequest request = new PutAdpRequest(bucketName, objectKey, adps);
        return this.putAdpTask(request);
    }

    @Override
    public PutAdpResult putAdpTask(String bucketName, String objectKey, List<Adp> adps, String notifyURL) throws Ks3ClientException, Ks3ServiceException {
        PutAdpRequest request = new PutAdpRequest(bucketName, objectKey, adps);
        request.setNotifyURL(notifyURL);
        return this.putAdpTask(request);
    }

    @Override
    public PutAdpResult putAdpTask(PutAdpRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (PutAdpResult)this.client.execute(this.auth, request, PutAdpResponse.class);
    }

    @Override
    public AdpTask getAdpTask(String taskid) throws Ks3ClientException, Ks3ServiceException {
        GetAdpRequest request = new GetAdpRequest(taskid);
        return this.getAdpTask(request);
    }

    @Override
    public AdpTask getAdpTask(GetAdpRequest request) throws Ks3ClientException, Ks3ServiceException {
        return (AdpTask)this.client.execute(this.auth, request, GetAdpResponse.class);
    }
}

