/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http;

import com.ksyun.ks3.MD5DigestCalculatingInputStream;
import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.dto.Ks3Result;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.Ks3ServiceException;
import com.ksyun.ks3.exception.client.ClientHttpException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentException;
import com.ksyun.ks3.exception.client.ClientInvalidDigestException;
import com.ksyun.ks3.http.HttpClientFactory;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpRequestBuilder;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.response.Ks3WebServiceResponse;
import com.ksyun.ks3.utils.Base64;
import com.ksyun.ks3.utils.Converter;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ks3CoreController {
    private static final Log log = LogFactory.getLog(Ks3CoreController.class);
    private HttpClientFactory factory = new HttpClientFactory();
    private HttpClient client;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <X extends Ks3WebServiceResponse<Y>, Y> Y execute(Authorization auth, Ks3WebServiceRequest request, Class<X> clazz) {
        if (request == null) {
            throw new Ks3ClientException("request can not be null");
        }
        log.debug((Object)("Ks3WebServiceRequest:" + request.getClass() + ";Ks3WebServiceResponse:" + clazz));
        Y result = null;
        try {
            if (auth == null || StringUtils.isBlank(auth.getAccessKeyId()) || StringUtils.isBlank(auth.getAccessKeySecret())) {
                throw new Ks3ClientException("AccessKeyId or AccessKeySecret can't be null");
            }
            if (request == null || clazz == null) {
                throw new IllegalArgumentException();
            }
            Y y = result = (Y)this.doExecute(auth, request, clazz);
            return y;
        }
        catch (RuntimeException e22) {
            Ks3ClientException e22;
            if (!(e22 instanceof Ks3ClientException)) {
                if (e22 instanceof IllegalArgumentException) {
                    ClientIllegalArgumentException ce = new ClientIllegalArgumentException(e22.getMessage());
                    ce.setStackTrace(e22.getStackTrace());
                    e22 = ce;
                } else {
                    e22 = new Ks3ClientException(e22);
                }
            }
            log.error((Object)e22);
            throw e22;
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new Ks3ClientException(e);
        }
    }

    private <X extends Ks3WebServiceResponse<Y>, Y> Y doExecute(Authorization auth, Ks3WebServiceRequest request, Class<X> clazz) throws IllegalStateException, IOException {
        String requestId;
        Timer.start();
        this.client = this.factory.createHttpClient();
        HttpResponse response = null;
        Request req = new Request();
        HttpRequestBase httpRequest = HttpRequestBuilder.build(request, req, auth);
        try {
            String location;
            log.debug((Object)httpRequest.getRequestLine());
            response = this.client.execute((HttpUriRequest)httpRequest);
            log.debug((Object)response.getStatusLine());
            if (response.getStatusLine().getStatusCode() == 307 && response.containsHeader("Location") && (location = response.getHeaders("Location")[0].getValue()).startsWith("http")) {
                log.debug((Object)("returned 307,retry request to " + location));
                this.restRequest((HttpRequest)httpRequest);
                httpRequest.setURI(new URI(location));
                response = this.client.execute((HttpUriRequest)httpRequest);
            }
            this.closeInputStream((HttpRequest)httpRequest);
            log.debug((Object)("finished send request to ks3 service and recive response from the service : " + Timer.end()));
        }
        catch (Exception e) {
            if (e instanceof Ks3ClientException) {
                throw (Ks3ClientException)e;
            }
            throw new ClientHttpException(e);
        }
        Ks3WebServiceResponse ksResponse = null;
        try {
            ksResponse = (Ks3WebServiceResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new Ks3ClientException("to instantiate " + clazz + " has occured an exception:(" + e + ")", e);
        }
        catch (IllegalAccessException e) {
            throw new Ks3ClientException("to instantiate " + clazz + " has occured an exception:(" + e + ")", e);
        }
        String string = requestId = response.getFirstHeader(HttpHeaders.RequestId.toString()) == null ? "" : response.getFirstHeader(HttpHeaders.RequestId.toString()).getValue();
        if (!this.success(response, ksResponse)) {
            throw new Ks3ServiceException(response, StringUtils.join(ksResponse.expectedStatus(), ",") + "(" + -1 + " is all statue codes)").convert(requestId);
        }
        Object result = ksResponse.handleResponse((HttpRequest)httpRequest, response);
        Map<String, String> ret = this.skipMD5Check(response, req);
        if (ret.size() == 2) {
            log.debug((Object)("returned etag is:" + ret.get("ETag")));
            if (!ret.get("ETag").equals(Converter.MD52ETag(ret.get("MD5")))) {
                throw new ClientInvalidDigestException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by KS3.  You may need to delete the data stored in KS3.");
            }
        } else {
            log.debug((Object)"client MD5 check skipped");
        }
        if (result instanceof Ks3Result) {
            ((Ks3Result)result).setRequestId(requestId);
        }
        log.debug((Object)("finished handle response : " + Timer.end()));
        return (Y)result;
    }

    private boolean success(HttpResponse response, Ks3WebServiceResponse<?> kscResponse) {
        int num = kscResponse.expectedStatus().length;
        int code = response.getStatusLine().getStatusCode();
        for (int i = 0; i < num; ++i) {
            if (kscResponse.expectedStatus()[i] == -1) {
                return true;
            }
            if (code != kscResponse.expectedStatus()[i]) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> skipMD5Check(HttpResponse rep, Request req) {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream content = req.getContent();
        if (content == null || !(content instanceof MD5DigestCalculatingInputStream)) {
            return map;
        }
        String clientmd5 = Base64.encodeAsString(((MD5DigestCalculatingInputStream)content).getMd5Digest());
        Header etagHeader = rep.getFirstHeader(HttpHeaders.ETag.toString());
        if (etagHeader == null) {
            return map;
        }
        String etag = etagHeader.getValue();
        if (StringUtils.isBlank(etag) || StringUtils.isBlank(clientmd5)) {
            return map;
        }
        map.put("ETag", etag);
        map.put("MD5", clientmd5);
        return map;
    }

    private void closeInputStream(HttpRequest req) throws IllegalStateException, IOException {
        InputStream input;
        HttpEntity entity = null;
        if (req instanceof HttpPut) {
            entity = ((HttpPut)req).getEntity();
        } else if (req instanceof HttpPost) {
            entity = ((HttpPost)req).getEntity();
        }
        if (entity != null && (input = entity.getContent()) != null) {
            input.close();
        }
    }

    private void restRequest(HttpRequest req) throws IllegalStateException, IOException {
        InputStream input;
        HttpEntity entity = null;
        if (req instanceof HttpPut) {
            entity = ((HttpPut)req).getEntity();
        } else if (req instanceof HttpPost) {
            entity = ((HttpPost)req).getEntity();
        }
        if (entity != null && (input = entity.getContent()) != null && input.markSupported()) {
            input.reset();
            input.mark(-1);
        }
    }
}

