/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http;

import com.ksyun.ks3.MD5DigestCalculatingInputStream;
import com.ksyun.ks3.RepeatableFileInputStream;
import com.ksyun.ks3.RepeatableInputStream;
import com.ksyun.ks3.config.ClientConfig;
import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.RepeatableInputStreamRequestEntity;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.request.SSECustomerKeyRequest;
import com.ksyun.ks3.signer.Signer;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BufferedHttpEntity;

public class HttpRequestBuilder {
    public static HttpRequestBase build(Ks3WebServiceRequest ks3Request, Request request, Authorization auth) {
        RepeatableInputStreamRequestEntity entity;
        String length;
        ks3Request.validateParams();
        request.getHeaders().putAll(ks3Request.getRequestConfig().getExtendHeaders());
        ks3Request.buildRequest(request);
        request.addHeaderIfNotContains(HttpHeaders.UserAgent.toString(), ks3Request.getRequestConfig().getUserAgent());
        request.addHeaderIfNotContains(HttpHeaders.ContentType.toString(), "application/xml");
        request.setEndpoint(ClientConfig.getConfig().getStr("ks3client.endpoint"));
        try {
            String signerString = ClientConfig.getConfig().getStr("ks3client.signer");
            Signer signer = (Signer)Class.forName(signerString).newInstance();
            signer.sign(auth, request);
        }
        catch (Exception e) {
            throw new Ks3ClientException(e);
        }
        HttpMethod method = request.getMethod();
        HttpPost httpRequest = null;
        if (request.getContent() != null && !(request.getContent() instanceof RepeatableInputStream) && !(request.getContent() instanceof RepeatableFileInputStream)) {
            request.setContent(new RepeatableInputStream(request.getContent(), 131072));
        }
        if (!HttpRequestBuilder.skipMD5Check(ks3Request, request) && !(request.getContent() instanceof MD5DigestCalculatingInputStream)) {
            request.setContent(new MD5DigestCalculatingInputStream(request.getContent()));
        }
        String url = "";
        String bucket = request.getBucket();
        String key = request.getKey();
        String endpoint = request.getEndpoint();
        String encodedParams = HttpUtils.encodeParams(request.getQueryParams());
        key = HttpUtils.urlEncode(key, true);
        int format = ClientConfig.getConfig().getInt("ks3client.urlformat");
        String protocol = ClientConfig.getConfig().getStr("httpclient.protocol ");
        url = format == 0 ? new StringBuffer(protocol + "://").append(StringUtils.isBlank(bucket) ? "" : bucket + ".").append(endpoint).append(StringUtils.isBlank(key) ? "" : "/" + key).toString() : new StringBuffer(protocol + "://").append(endpoint).append(StringUtils.isBlank(bucket) ? "" : "/" + bucket).append(StringUtils.isBlank(key) ? "" : "/" + key).toString();
        if (!StringUtils.isBlank(encodedParams)) {
            url = url + "?" + encodedParams;
        }
        InputStream requestBody = request.getContent();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(url);
            if (requestBody != null) {
                length = request.getHeaders().get(HttpHeaders.ContentLength.toString());
                entity = new RepeatableInputStreamRequestEntity(requestBody, length);
                if (!StringUtils.checkLong(length) || Long.parseLong(length) < 0L) {
                    try {
                        entity = new BufferedHttpEntity((HttpEntity)entity);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new Ks3ClientException("\u521d\u59cb\u5316Http Request\u51fa\u9519(" + e + ")", e);
                    }
                }
                postMethod.setEntity((HttpEntity)entity);
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.GET) {
            HttpGet getMethod = new HttpGet(url);
            httpRequest = getMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(url);
            httpRequest = putMethod;
            putMethod.getParams().setParameter("http.protocol.expect-continue", (Object)true);
            if (requestBody != null) {
                length = request.getHeaders().get(HttpHeaders.ContentLength.toString());
                entity = null;
                if (length == null || length.trim().equals("0")) {
                    try {
                        entity = new RepeatableInputStreamRequestEntity(requestBody, "-1");
                        entity = new BufferedHttpEntity((HttpEntity)entity);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new Ks3ClientException("\u521d\u59cb\u5316Http Request\u51fa\u9519(" + e + ")", e);
                    }
                } else {
                    entity = new RepeatableInputStreamRequestEntity(requestBody, length);
                }
                putMethod.setEntity((HttpEntity)entity);
            }
        } else if (method == HttpMethod.DELETE) {
            HttpDelete deleteMethod = new HttpDelete(url);
            httpRequest = deleteMethod;
        } else if (method == HttpMethod.HEAD) {
            HttpHead headMethod = new HttpHead(url);
            httpRequest = headMethod;
        } else {
            throw new Ks3ClientException("Unknow http method : " + (Object)((Object)method));
        }
        for (Map.Entry<String, String> aHeader : request.getHeaders().entrySet()) {
            if (httpRequest.containsHeader(aHeader.getKey())) continue;
            httpRequest.setHeader(aHeader.getKey(), aHeader.getValue());
        }
        httpRequest.removeHeaders(HttpHeaders.ContentLength.toString());
        return httpRequest;
    }

    private static boolean skipMD5Check(Ks3WebServiceRequest wsReq, Request req) {
        if (wsReq instanceof SSECustomerKeyRequest) {
            if (((SSECustomerKeyRequest)((Object)wsReq)).getSseCustomerKey() != null) {
                return true;
            }
            if (req.getContent() == null) {
                return true;
            }
            return !StringUtils.isBlank(req.getHeaders().get(HttpHeaders.ContentMD5.toString()));
        }
        return true;
    }
}

