/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http;

import com.ksyun.ks3.config.ClientConfig;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.ConnectionManagerFactory;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClientFactory {
    public HttpClient createHttpClient() {
        ClientConfig config = ClientConfig.getConfig();
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)config.getInt("httpclient.connectionTimeout"));
        HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)config.getInt("httpclient.socketTimeout"));
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpClientParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpClientParams, (boolean)true);
        int socketSendBufferSizeHint = config.getInt("httpclient.socketSendBufferSizeHint");
        int socketReceiveBufferSizeHint = config.getInt("httpclient.socketReceiveBufferSzieHint");
        if (socketSendBufferSizeHint > 0 || socketReceiveBufferSizeHint > 0) {
            HttpConnectionParams.setSocketBufferSize((HttpParams)httpClientParams, (int)Math.max(socketSendBufferSizeHint, socketReceiveBufferSizeHint));
        }
        PoolingClientConnectionManager connectionManager = ConnectionManagerFactory.createPoolingClientConnManager((HttpParams)httpClientParams);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpClientParams);
        httpClient.setRedirectStrategy((RedirectStrategy)new LocationHeaderNotRequiredRedirectStrategy());
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(config.getInt("httpclient.maxRetry"), false));
        try {
            Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
            SSLSocketFactory sf = new SSLSocketFactory(SSLContext.getDefault(), SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sf);
            SchemeRegistry sr = connectionManager.getSchemeRegistry();
            sr.register(http);
            sr.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Ks3ClientException("Unable to access default SSL context", e);
        }
        String proxyHost = config.getStr("httpclient.proxyHost");
        int proxyPort = config.getInt("httpclient.proxyPort");
        if (proxyHost != null && proxyPort > 0) {
            HttpHost proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHttpHost);
            String proxyUsername = config.getStr("httpclient.ProxyUserName");
            String proxyPassword = config.getStr("httpclient.ProxyPassword");
            String proxyDomain = config.getStr("httpclient.ProxyDomain");
            String proxyWorkstation = config.getStr("httpclient.ProxyWorkStation");
            if (proxyUsername != null && proxyPassword != null) {
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
            if (config.getBoolean("httpclient.isPreemptiveBasicProxyAuth")) {
                httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveProxyAuth(proxyHttpHost), 0);
            }
        }
        return httpClient;
    }

    private static class PreemptiveProxyAuth
    implements HttpRequestInterceptor {
        private final HttpHost proxyHost;

        public PreemptiveProxyAuth(HttpHost proxyHost) {
            this.proxyHost = proxyHost;
        }

        public void process(HttpRequest request, HttpContext context) {
            BasicScheme basicScheme = new BasicScheme(ChallengeState.PROXY);
            if (context.getAttribute("http.auth.auth-cache") == null) {
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(this.proxyHost, (AuthScheme)basicScheme);
                context.setAttribute("http.auth.auth-cache", (Object)authCache);
            } else {
                AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
                authCache.put(this.proxyHost, (AuthScheme)basicScheme);
            }
        }
    }

    private static final class LocationHeaderNotRequiredRedirectStrategy
    extends DefaultRedirectStrategy {
        private LocationHeaderNotRequiredRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            int statusCode = response.getStatusLine().getStatusCode();
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader == null && statusCode == 301) {
                return false;
            }
            return super.isRedirected(request, response, context);
        }
    }
}

