/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.config;

import com.ksyun.ks3.config.AWSConfigLoader;
import com.ksyun.ks3.config.ConfigLoader;
import com.ksyun.ks3.config.DefaultConfigLoader;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConfig {
    private static final Log log = LogFactory.getLog(ClientConfig.class);
    public static final String CONNECTION_TIMEOUT = "httpclient.connectionTimeout";
    public static final String SOCKET_TIMEOUT = "httpclient.socketTimeout";
    public static final String SOCKET_SEND_BUFFER_SIZE_HINT = "httpclient.socketSendBufferSizeHint";
    public static final String SOCKET_RECEIVE_BUFFER_SIZE_HINT = "httpclient.socketReceiveBufferSzieHint";
    public static final String MAX_RETRY = "httpclient.maxRetry";
    public static final String CONNECTION_TTL = "httpclient.connnetionTTL";
    public static final String MAX_CONNECTIONS = "httpclient.maxConnections";
    public static final String PROXY_HOST = "httpclient.proxyHost";
    public static final String PROXY_PORT = "httpclient.proxyPort";
    public static final String PROXY_USER_NAME = "httpclient.ProxyUserName";
    public static final String PROXY_PASSWORD = "httpclient.ProxyPassword";
    public static final String PROXY_DAMAIN = "httpclient.ProxyDomain";
    public static final String PROXY_WORKSTATION = "httpclient.ProxyWorkStation";
    public static final String IS_PREEMPTIVE_BASIC_PROXY_AUTH = "httpclient.isPreemptiveBasicProxyAuth";
    public static final String HTTP_PROTOCOL = "httpclient.protocol ";
    public static final String END_POINT = "ks3client.endpoint";
    public static final String CDN_END_POINT = "ks3client.cdn.endpoint";
    public static final String CLIENT_SIGNER = "ks3client.signer";
    public static final String CLIENT_URLFORMAT = "ks3client.urlformat";
    public static final String HEADER_PREFIX = "ks3client.header.prefix";
    public static final String USER_META_PREFIX = "ks3client.usermeta.prefix";
    public static final String GRANTEE_ALLUSER = "ks3client.grantee.alluser";
    public static final String AUTH_HEADER_PREFIX = "ks3client.auth.prefix";
    private static List<ConfigLoader> configLoaders = new ArrayList<ConfigLoader>();
    private static boolean reload = true;
    private static ClientConfig instance;
    private Map<String, String> config = new HashMap<String, String>();

    public static void addConfigLoader(ConfigLoader loader) {
        if (ClientConfig.getConfigLoader(loader.getClass()) == null) {
            reload = true;
            configLoaders.add(loader);
        }
    }

    public static ConfigLoader getConfigLoader(Class<?> clazz) {
        for (ConfigLoader loader : configLoaders) {
            if (!loader.getClass().equals(clazz)) continue;
            return loader;
        }
        return null;
    }

    private ClientConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientConfig getConfig() {
        Class<ClientConfig> clazz = ClientConfig.class;
        synchronized (ClientConfig.class) {
            if (instance == null) {
                instance = new ClientConfig();
            }
            if (reload) {
                for (int i = 0; i < configLoaders.size(); ++i) {
                    ConfigLoader loader = configLoaders.get(i);
                    instance = loader.load(instance);
                    log.debug((Object)("complete load config from " + loader.getClass()));
                }
                reload = false;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getStr(String key) {
        if (this.config.containsKey(key = key.toLowerCase())) {
            return this.get(key);
        }
        return null;
    }

    public int getInt(String key) {
        if (this.config.containsKey(key = key.toLowerCase())) {
            return Integer.parseInt(this.get(key));
        }
        return -1;
    }

    public long getLong(String key) {
        if (this.config.containsKey(key = key.toLowerCase())) {
            return Long.parseLong(this.get(key));
        }
        return -1L;
    }

    public boolean getBoolean(String key) {
        key = key.toLowerCase();
        return "true".equals(this.get(key));
    }

    private String get(String key) {
        return this.config.get(key);
    }

    public void set(String key, String value) {
        if (StringUtils.isBlank(key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("key");
        }
        if ("null".equals(value)) {
            value = null;
        }
        this.config.put(key.toLowerCase(), value);
    }

    public static boolean isAws() {
        return ClientConfig.getConfigLoader(AWSConfigLoader.class) != null;
    }

    static {
        configLoaders.add(new DefaultConfigLoader());
        instance = null;
    }
}

