/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.io;

import com.jfinal.template.io.FDBigInt;

public class FloatingDecimal {
    boolean isExceptional;
    boolean isNegative;
    int decExponent;
    char[] digits;
    int nDigits;
    int bigIntExp;
    int bigIntNBits;
    boolean mustSetRoundDir = false;
    boolean fromHex = false;
    int roundDir = 0;
    static final long signMask = Long.MIN_VALUE;
    static final long expMask = 0x7FF0000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expShift = 52;
    static final int expBias = 1023;
    static final long fractHOB = 0x10000000000000L;
    static final long expOne = 0x3FF0000000000000L;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final int maxDecimalDigits = 15;
    static final int maxDecimalExponent = 308;
    static final int minDecimalExponent = -324;
    static final int bigDecimalExponent = 324;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int singleSignMask = Integer.MIN_VALUE;
    static final int singleExpMask = 2139095040;
    static final int singleFractMask = 0x7FFFFF;
    static final int singleExpShift = 23;
    static final int singleFractHOB = 0x800000;
    static final int singleExpBias = 127;
    static final int singleMaxDecimalDigits = 7;
    static final int singleMaxDecimalExponent = 38;
    static final int singleMinDecimalExponent = -45;
    static final int intDecimalDigits = 9;
    private static FDBigInt[] b5p;
    private static ThreadLocal perThreadBuffer;
    private static final int[] small5pow;
    private static final long[] long5pow;
    private static final int[] n5bits;
    private static final char[] infinity;
    private static final char[] notANumber;
    private static final char[] zero;

    private static int countBits(long v) {
        if (v == 0L) {
            return 0;
        }
        while ((v & 0xFF00000000000000L) == 0L) {
            v <<= 8;
        }
        while (v > 0L) {
            v <<= 1;
        }
        int n = 0;
        while ((v & 0xFFFFFFFFFFFFFFL) != 0L) {
            v <<= 8;
            n += 8;
        }
        while (v != 0L) {
            v <<= 1;
            ++n;
        }
        return n;
    }

    private static synchronized FDBigInt big5pow(int p) {
        assert (p >= 0) : p;
        if (b5p == null) {
            b5p = new FDBigInt[p + 1];
        } else if (b5p.length <= p) {
            FDBigInt[] t = new FDBigInt[p + 1];
            System.arraycopy(b5p, 0, t, 0, b5p.length);
            b5p = t;
        }
        if (b5p[p] != null) {
            return b5p[p];
        }
        if (p < small5pow.length) {
            FloatingDecimal.b5p[p] = new FDBigInt(small5pow[p]);
            return FloatingDecimal.b5p[p];
        }
        if (p < long5pow.length) {
            FloatingDecimal.b5p[p] = new FDBigInt(long5pow[p]);
            return FloatingDecimal.b5p[p];
        }
        int q = p >> 1;
        int r = p - q;
        FDBigInt bigq = b5p[q];
        if (bigq == null) {
            bigq = FloatingDecimal.big5pow(q);
        }
        if (r < small5pow.length) {
            FloatingDecimal.b5p[p] = bigq.mult(small5pow[r]);
            return FloatingDecimal.b5p[p];
        }
        FDBigInt bigr = b5p[r];
        if (bigr == null) {
            bigr = FloatingDecimal.big5pow(r);
        }
        FloatingDecimal.b5p[p] = bigq.mult(bigr);
        return FloatingDecimal.b5p[p];
    }

    private static FDBigInt multPow52(FDBigInt v, int p5, int p2) {
        if (p5 != 0) {
            v = p5 < small5pow.length ? v.mult(small5pow[p5]) : v.mult(FloatingDecimal.big5pow(p5));
        }
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    private static FDBigInt constructPow52(int p5, int p2) {
        FDBigInt v = new FDBigInt(FloatingDecimal.big5pow(p5));
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    private void developLongDigits(int decExponent, long lvalue, long insignificant) {
        int digitno;
        char[] digits;
        int ndigits;
        int i = 0;
        while (insignificant >= 10L) {
            insignificant /= 10L;
            ++i;
        }
        if (i != 0) {
            long pow10 = long5pow[i] << i;
            long residue = lvalue % pow10;
            lvalue /= pow10;
            decExponent += i;
            if (residue >= pow10 >> 1) {
                ++lvalue;
            }
        }
        if (lvalue <= Integer.MAX_VALUE) {
            assert (lvalue > 0L) : lvalue;
            int ivalue = (int)lvalue;
            ndigits = 10;
            digits = (char[])perThreadBuffer.get();
            digitno = ndigits - 1;
            int c = ivalue % 10;
            ivalue /= 10;
            while (c == 0) {
                ++decExponent;
                c = ivalue % 10;
                ivalue /= 10;
            }
            while (ivalue != 0) {
                digits[digitno--] = (char)(c + 48);
                ++decExponent;
                c = ivalue % 10;
                ivalue /= 10;
            }
            digits[digitno] = (char)(c + 48);
        } else {
            ndigits = 20;
            digits = (char[])perThreadBuffer.get();
            digitno = ndigits - 1;
            int c = (int)(lvalue % 10L);
            lvalue /= 10L;
            while (c == 0) {
                ++decExponent;
                c = (int)(lvalue % 10L);
                lvalue /= 10L;
            }
            while (lvalue != 0L) {
                digits[digitno--] = (char)(c + 48);
                ++decExponent;
                c = (int)(lvalue % 10L);
                lvalue /= 10L;
            }
            digits[digitno] = (char)(c + 48);
        }
        char[] result = new char[ndigits -= digitno];
        System.arraycopy(digits, digitno, result, 0, ndigits);
        this.digits = result;
        this.decExponent = decExponent + 1;
        this.nDigits = ndigits;
    }

    private void roundup() {
        int i = this.nDigits - 1;
        char q = this.digits[i];
        if (q == '9') {
            while (q == '9' && i > 0) {
                this.digits[i] = 48;
                q = this.digits[--i];
            }
            if (q == '9') {
                ++this.decExponent;
                this.digits[0] = 49;
                return;
            }
        }
        this.digits[i] = (char)(q + '\u0001');
    }

    public FloatingDecimal(double d) {
        int nSignificantBits;
        long dBits = Double.doubleToLongBits(d);
        if ((dBits & Long.MIN_VALUE) != 0L) {
            this.isNegative = true;
            dBits ^= Long.MIN_VALUE;
        } else {
            this.isNegative = false;
        }
        int binExp = (int)((dBits & 0x7FF0000000000000L) >> 52);
        long fractBits = dBits & 0xFFFFFFFFFFFFFL;
        if (binExp == 2047) {
            this.isExceptional = true;
            if (fractBits == 0L) {
                this.digits = infinity;
            } else {
                this.digits = notANumber;
                this.isNegative = false;
            }
            this.nDigits = this.digits.length;
            return;
        }
        this.isExceptional = false;
        if (binExp == 0) {
            if (fractBits == 0L) {
                this.decExponent = 0;
                this.digits = zero;
                this.nDigits = 1;
                return;
            }
            while ((fractBits & 0x10000000000000L) == 0L) {
                fractBits <<= 1;
                --binExp;
            }
            nSignificantBits = 52 + binExp + 1;
            ++binExp;
        } else {
            fractBits |= 0x10000000000000L;
            nSignificantBits = 53;
        }
        this.dtoa(binExp -= 1023, fractBits, nSignificantBits);
    }

    public FloatingDecimal(float f) {
        int nSignificantBits;
        int fBits = Float.floatToIntBits(f);
        if ((fBits & Integer.MIN_VALUE) != 0) {
            this.isNegative = true;
            fBits ^= Integer.MIN_VALUE;
        } else {
            this.isNegative = false;
        }
        int binExp = (fBits & 0x7F800000) >> 23;
        int fractBits = fBits & 0x7FFFFF;
        if (binExp == 255) {
            this.isExceptional = true;
            if ((long)fractBits == 0L) {
                this.digits = infinity;
            } else {
                this.digits = notANumber;
                this.isNegative = false;
            }
            this.nDigits = this.digits.length;
            return;
        }
        this.isExceptional = false;
        if (binExp == 0) {
            if (fractBits == 0) {
                this.decExponent = 0;
                this.digits = zero;
                this.nDigits = 1;
                return;
            }
            while ((fractBits & 0x800000) == 0) {
                fractBits <<= 1;
                --binExp;
            }
            nSignificantBits = 23 + binExp + 1;
            ++binExp;
        } else {
            fractBits |= 0x800000;
            nSignificantBits = 24;
        }
        this.dtoa(binExp -= 127, (long)fractBits << 29, nSignificantBits);
    }

    private void dtoa(int binExp, long fractBits, int nSignificantBits) {
        long lowDigitDifference;
        boolean high;
        boolean low;
        int nFractBits = FloatingDecimal.countBits(fractBits);
        int nTinyBits = Math.max(0, nFractBits - binExp - 1);
        if (binExp <= 62 && binExp >= -21 && nTinyBits < long5pow.length && nFractBits + n5bits[nTinyBits] < 64 && nTinyBits == 0) {
            long halfULP = binExp > nSignificantBits ? 1L << binExp - nSignificantBits - 1 : 0L;
            fractBits = binExp >= 52 ? (fractBits <<= binExp - 52) : (fractBits >>>= 52 - binExp);
            this.developLongDigits(0, fractBits, halfULP);
            return;
        }
        double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFEFFFFFFFFFFFFFL);
        int decExp = (int)Math.floor((d2 - 1.5) * 0.289529654 + 0.176091259 + (double)binExp * 0.301029995663981);
        int B5 = Math.max(0, -decExp);
        int B2 = B5 + nTinyBits + binExp;
        int S5 = Math.max(0, decExp);
        int S2 = S5 + nTinyBits;
        int M5 = B5;
        int M2 = B2 - nSignificantBits;
        fractBits >>>= 53 - nFractBits;
        int common2factor = Math.min(B2 -= nFractBits - 1, S2);
        B2 -= common2factor;
        S2 -= common2factor;
        M2 -= common2factor;
        if (nFractBits == 1) {
            --M2;
        }
        if (M2 < 0) {
            B2 -= M2;
            S2 -= M2;
            M2 = 0;
        }
        this.digits = new char[18];
        char[] digits = this.digits;
        int ndigit = 0;
        int Bbits = nFractBits + B2 + (B5 < n5bits.length ? n5bits[B5] : B5 * 3);
        int tenSbits = S2 + 1 + (S5 + 1 < n5bits.length ? n5bits[S5 + 1] : (S5 + 1) * 3);
        if (Bbits < 64 && tenSbits < 64) {
            if (Bbits < 32 && tenSbits < 32) {
                int b = (int)fractBits * small5pow[B5] << B2;
                int s = small5pow[S5] << S2;
                int m = small5pow[M5] << M2;
                int tens = s * 10;
                ndigit = 0;
                int q = b / s;
                low = (b = 10 * (b % s)) < (m *= 10);
                boolean bl = high = b + m > tens;
                assert (q < 10) : q;
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    digits[ndigit++] = (char)(48 + q);
                }
                if (decExp < -3 || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = b / s;
                    b = 10 * (b % s);
                    m *= 10;
                    assert (q < 10) : q;
                    if ((long)m > 0L) {
                        low = b < m;
                        high = b + m > tens;
                    } else {
                        low = true;
                        high = true;
                    }
                    digits[ndigit++] = (char)(48 + q);
                }
                lowDigitDifference = (b << 1) - tens;
            } else {
                long b = fractBits * long5pow[B5] << B2;
                long s = long5pow[S5] << S2;
                long m = long5pow[M5] << M2;
                long tens = s * 10L;
                ndigit = 0;
                int q = (int)(b / s);
                low = (b = 10L * (b % s)) < (m *= 10L);
                boolean bl = high = b + m > tens;
                assert (q < 10) : q;
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    digits[ndigit++] = (char)(48 + q);
                }
                if (decExp < -3 || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = (int)(b / s);
                    b = 10L * (b % s);
                    m *= 10L;
                    assert (q < 10) : q;
                    if (m > 0L) {
                        low = b < m;
                        high = b + m > tens;
                    } else {
                        low = true;
                        high = true;
                    }
                    digits[ndigit++] = (char)(48 + q);
                }
                lowDigitDifference = (b << 1) - tens;
            }
        } else {
            FDBigInt Bval = FloatingDecimal.multPow52(new FDBigInt(fractBits), B5, B2);
            FDBigInt Sval = FloatingDecimal.constructPow52(S5, S2);
            FDBigInt Mval = FloatingDecimal.constructPow52(M5, M2);
            int shiftBias = Sval.normalizeMe();
            Bval.lshiftMe(shiftBias);
            Mval.lshiftMe(shiftBias);
            FDBigInt tenSval = Sval.mult(10);
            ndigit = 0;
            int q = Bval.quoRemIteration(Sval);
            Mval = Mval.mult(10);
            low = Bval.cmp(Mval) < 0;
            boolean bl = high = Bval.add(Mval).cmp(tenSval) > 0;
            assert (q < 10) : q;
            if (q == 0 && !high) {
                --decExp;
            } else {
                digits[ndigit++] = (char)(48 + q);
            }
            if (decExp < -3 || decExp >= 8) {
                low = false;
                high = false;
            }
            while (!low && !high) {
                q = Bval.quoRemIteration(Sval);
                Mval = Mval.mult(10);
                assert (q < 10) : q;
                low = Bval.cmp(Mval) < 0;
                high = Bval.add(Mval).cmp(tenSval) > 0;
                digits[ndigit++] = (char)(48 + q);
            }
            if (high && low) {
                Bval.lshiftMe(1);
                lowDigitDifference = Bval.cmp(tenSval);
            } else {
                lowDigitDifference = 0L;
            }
        }
        this.decExponent = decExp + 1;
        this.digits = digits;
        this.nDigits = ndigit;
        if (high) {
            if (low) {
                if (lowDigitDifference == 0L) {
                    if ((digits[this.nDigits - 1] & '\u0001') != 0) {
                        this.roundup();
                    }
                } else if (lowDigitDifference > 0L) {
                    this.roundup();
                }
            } else {
                this.roundup();
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.nDigits + 8);
        if (this.isNegative) {
            result.append('-');
        }
        if (this.isExceptional) {
            result.append(this.digits, 0, this.nDigits);
        } else {
            result.append("0.");
            result.append(this.digits, 0, this.nDigits);
            result.append('e');
            result.append(this.decExponent);
        }
        return new String(result);
    }

    public String toJavaFormatString() {
        char[] result = (char[])perThreadBuffer.get();
        int i = this.getChars(result);
        return new String(result, 0, i);
    }

    public int getChars(char[] result) {
        assert (this.nDigits <= 19) : this.nDigits;
        int i = 0;
        if (this.isNegative) {
            result[0] = 45;
            i = 1;
        }
        if (this.isExceptional) {
            System.arraycopy(this.digits, 0, result, i, this.nDigits);
            i += this.nDigits;
        } else if (this.decExponent > 0 && this.decExponent < 8) {
            int charLength = Math.min(this.nDigits, this.decExponent);
            System.arraycopy(this.digits, 0, result, i, charLength);
            i += charLength;
            if (charLength < this.decExponent) {
                charLength = this.decExponent - charLength;
                System.arraycopy(zero, 0, result, i, charLength);
                i += charLength;
                result[i++] = 46;
                result[i++] = 48;
            } else {
                result[i++] = 46;
                if (charLength < this.nDigits) {
                    int t = this.nDigits - charLength;
                    System.arraycopy(this.digits, charLength, result, i, t);
                    i += t;
                } else {
                    result[i++] = 48;
                }
            }
        } else if (this.decExponent <= 0 && this.decExponent > -3) {
            result[i++] = 48;
            result[i++] = 46;
            if (this.decExponent != 0) {
                System.arraycopy(zero, 0, result, i, -this.decExponent);
                i -= this.decExponent;
            }
            System.arraycopy(this.digits, 0, result, i, this.nDigits);
            i += this.nDigits;
        } else {
            int e;
            result[i++] = this.digits[0];
            result[i++] = 46;
            if (this.nDigits > 1) {
                System.arraycopy(this.digits, 1, result, i, this.nDigits - 1);
                i += this.nDigits - 1;
            } else {
                result[i++] = 48;
            }
            result[i++] = 69;
            if (this.decExponent <= 0) {
                result[i++] = 45;
                e = -this.decExponent + 1;
            } else {
                e = this.decExponent - 1;
            }
            if (e <= 9) {
                result[i++] = (char)(e + 48);
            } else if (e <= 99) {
                result[i++] = (char)(e / 10 + 48);
                result[i++] = (char)(e % 10 + 48);
            } else {
                result[i++] = (char)(e / 100 + 48);
                result[i++] = (char)((e %= 100) / 10 + 48);
                result[i++] = (char)(e % 10 + 48);
            }
        }
        return i;
    }

    static {
        perThreadBuffer = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new char[26];
            }
        };
        small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
        n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
        infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
        notANumber = new char[]{'N', 'a', 'N'};
        zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    }
}

