/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.wechat.connect;

import org.springframework.social.oauth2.AbstractOAuth2ServiceProvider;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Template;
import org.springframework.social.wechat.api.Wechat;
import org.springframework.social.wechat.api.impl.WechatImpl;
import org.springframework.social.wechat.connect.WechatOAuth2Template;

public class WechatServiceProvider<T extends Wechat>
extends AbstractOAuth2ServiceProvider<T> {
    public WechatServiceProvider(String appId, String appSecret) {
        super((OAuth2Operations)WechatServiceProvider.getOAuth2Template(appId, appSecret, "https://open.weixin.qq.com/connect/qrconnect"));
    }

    public WechatServiceProvider(String appId, String appSecret, String authorizeUrl) {
        super((OAuth2Operations)WechatServiceProvider.getOAuth2Template(appId, appSecret, authorizeUrl));
    }

    private static OAuth2Template getOAuth2Template(String appId, String appSecret, String authorizeUrl) {
        WechatOAuth2Template oauth2Template = new WechatOAuth2Template(appId, appSecret, authorizeUrl, "https://api.weixin.qq.com/sns/oauth2/access_token");
        oauth2Template.setUseParametersForClientAuthentication(true);
        return oauth2Template;
    }

    public T getApi(String accessToken) {
        return (T)new WechatImpl(accessToken);
    }
}

