/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.wechat.connect;

import java.util.Map;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.GrantType;
import org.springframework.social.oauth2.OAuth2Parameters;
import org.springframework.social.oauth2.OAuth2Template;
import org.springframework.social.wechat.WechatMappingJackson2HttpMessageConverter;
import org.springframework.social.wechat.connect.WechatAccessGrant;
import org.springframework.social.wechat.utils.TemplateUtil;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class WechatOAuth2Template
extends OAuth2Template {
    public WechatOAuth2Template(String clientId, String clientSecret, String authorizeUrl, String accessTokenUrl) {
        super(clientId, clientSecret, authorizeUrl, accessTokenUrl);
    }

    public WechatOAuth2Template(String clientId, String clientSecret, String authorizeUrl, String authenticateUrl, String accessTokenUrl) {
        super(clientId, clientSecret, authorizeUrl, authenticateUrl, accessTokenUrl);
    }

    protected AccessGrant postForAccessGrant(String accessTokenUrl, MultiValueMap<String, String> parameters) {
        if ("authorization_code".equals(parameters.getFirst((Object)"grant_type"))) {
            parameters.set((Object)"appid", parameters.getFirst((Object)"client_id"));
            parameters.set((Object)"secret", parameters.getFirst((Object)"client_secret"));
            parameters.remove((Object)"client_id");
            parameters.remove((Object)"client_secret");
        }
        return super.postForAccessGrant(accessTokenUrl, parameters);
    }

    protected WechatAccessGrant createAccessGrant(String accessToken, String scope, String refreshToken, Long expiresIn, Map<String, Object> response) {
        return new WechatAccessGrant(accessToken, scope, refreshToken, expiresIn, (String)response.get("openid"), (String)response.get("unionid"));
    }

    protected RestTemplate createRestTemplate() {
        return TemplateUtil.addHttpMessageConverter(super.createRestTemplate(), new WechatMappingJackson2HttpMessageConverter());
    }

    public String buildAuthorizeUrl(OAuth2Parameters parameters) {
        return this.replaceParamKey(super.buildAuthorizeUrl(parameters));
    }

    public String buildAuthorizeUrl(GrantType grantType, OAuth2Parameters parameters) {
        return this.replaceParamKey(super.buildAuthorizeUrl(grantType, parameters));
    }

    protected String replaceParamKey(String url) {
        return url.replace("client_id", "appid").replace("client_secret", "secret");
    }
}

