/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.wechat.connect;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.wechat.api.WechatMp;
import org.springframework.social.wechat.connect.WechatAccessGrant;
import org.springframework.social.wechat.connect.WechatAdapter;
import org.springframework.social.wechat.connect.WechatServiceProvider;

public class WechatMpConnectionFactory
extends OAuth2ConnectionFactory<WechatMp> {
    public WechatMpConnectionFactory(String appId, String appSecret) {
        this(appId, appSecret, new WechatAdapter<WechatMp>());
    }

    public WechatMpConnectionFactory(String appId, String appSecret, ApiAdapter<WechatMp> apiAdapter) {
        super("wechatmp", new WechatServiceProvider(appId, appSecret, "https://open.weixin.qq.com/connect/oauth2/authorize"), apiAdapter);
    }

    protected String extractProviderUserId(AccessGrant accessGrant) {
        return ((WechatAccessGrant)accessGrant).getOpenid();
    }
}

