/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.wechat.connect;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.wechat.api.Wechat;
import org.springframework.social.wechat.connect.WechatAccessGrant;
import org.springframework.social.wechat.connect.WechatAdapter;
import org.springframework.social.wechat.connect.WechatServiceProvider;

public class WechatConnectionFactory
extends OAuth2ConnectionFactory<Wechat> {
    public WechatConnectionFactory(String appId, String appSecret) {
        this(appId, appSecret, new WechatAdapter<Wechat>());
    }

    public WechatConnectionFactory(String appId, String appSecret, ApiAdapter<Wechat> apiAdapter) {
        super("wechat", new WechatServiceProvider(appId, appSecret), apiAdapter);
    }

    protected String extractProviderUserId(AccessGrant accessGrant) {
        return ((WechatAccessGrant)accessGrant).getOpenid();
    }
}

