/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.wechat.api.impl;

import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.oauth2.TokenStrategy;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.social.wechat.WechatMappingJackson2HttpMessageConverter;
import org.springframework.social.wechat.api.UserOperations;
import org.springframework.social.wechat.api.UserTemplate;
import org.springframework.social.wechat.api.Wechat;
import org.springframework.social.wechat.api.impl.WechatErrorHandler;
import org.springframework.social.wechat.utils.TemplateUtil;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class WechatImpl
extends AbstractOAuth2ApiBinding
implements Wechat {
    private UserOperations userOperations;

    public WechatImpl(String accessToken) {
        super(accessToken, TokenStrategy.ACCESS_TOKEN_PARAMETER);
        this.userOperations = new UserTemplate((RestOperations)TemplateUtil.addHttpMessageConverter(this.getRestTemplate(), new WechatMappingJackson2HttpMessageConverter()), accessToken);
    }

    @Override
    public UserOperations userOperations() {
        return this.userOperations;
    }

    @Override
    public RestOperations restOperations() {
        return this.getRestTemplate();
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        super.setRequestFactory(ClientHttpRequestFactorySelector.bufferRequests((ClientHttpRequestFactory)requestFactory));
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.BEARER_DRAFT_2;
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
        super.configureRestTemplate(restTemplate);
        restTemplate.setErrorHandler((ResponseErrorHandler)new WechatErrorHandler());
    }
}

