/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.wechat.api.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.UncategorizedApiException;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class WechatErrorHandler
extends DefaultResponseErrorHandler {
    public void handleError(ClientHttpResponse response) throws IOException {
        if (HttpStatus.Series.CLIENT_ERROR.equals((Object)response.getStatusCode().series())) {
            Map<String, Object> errorDetails = this.extractErrorDetailsFromResponse(response);
            throw new UncategorizedApiException("wechat", errorDetails.containsKey("errmsg") ? (String)errorDetails.get("errmsg") : "Unknown error", null);
        }
        this.handleUncategorizedError(response);
    }

    private void handleUncategorizedError(ClientHttpResponse response) {
        try {
            super.handleError(response);
        }
        catch (Exception e) {
            throw new UncategorizedApiException("wechat", "Error consuming wechat REST api", (Throwable)e);
        }
    }

    private Map<String, Object> extractErrorDetailsFromResponse(ClientHttpResponse response) throws IOException {
        try {
            return (Map)new ObjectMapper(new JsonFactory()).readValue(response.getBody(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonParseException e) {
            return Collections.emptyMap();
        }
    }
}

